/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.opengl.GL11;

public class TileRenderBottlingMachine
extends TileRenderIE {
    ModelIEObj model = new ModelIEObj("immersiveengineering:models/bottlingMachine.obj"){

        @Override
        public IIcon getBlockIcon(String groupName) {
            if (groupName.equalsIgnoreCase("conveyors")) {
                return IEContent.blockMetalDevice.getIcon(0, 11);
            }
            return IEContent.blockMetalMultiblocks.getIcon(0, 12);
        }
    };

    @Override
    public void renderStatic(TileEntity tile, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix) {
        TileEntityBottlingMachine bottler = (TileEntityBottlingMachine)tile;
        translationMatrix.translate(0.5, 0.0, 0.5);
        rotationMatrix.rotate(Math.toRadians(bottler.facing == 3 ? 180.0 : (bottler.facing == 4 ? 90.0 : (bottler.facing == 5 ? -90.0 : 0.0))), 0.0, 1.0, 0.0);
        if (bottler.mirrored) {
            translationMatrix.scale(new Vertex(bottler.facing < 4 ? -1.0f : 1.0f, 1.0f, bottler.facing > 3 ? -1.0f : 1.0f));
        }
        this.model.render(tile, tes, translationMatrix, rotationMatrix, 0, bottler.mirrored, "conveyors", "base");
    }

    @Override
    public void renderDynamic(TileEntity tile, double x, double y, double z, float f) {
        TileEntityBottlingMachine bottler = (TileEntityBottlingMachine)tile;
        if (!bottler.formed || bottler.pos != 4) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)(bottler.facing == 3 ? 180.0 : (bottler.facing == 4 ? 90.0 : (bottler.facing == 5 ? -90.0 : 0.0))), (double)0.0, (double)1.0, (double)0.0);
        double shift = 0.3358;
        Matrix4 translationMatrix = new Matrix4();
        Matrix4 rotationMatrix = new Matrix4();
        if (bottler.mirrored) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glTranslated((double)(shift / 2.0), (double)0.0, (double)0.0);
        double d0 = 0.05867077;
        double d1 = 0.08265846;
        double tapShift = 0.0;
        for (int i = 0; i < bottler.inventory.length; ++i) {
            double fill;
            if (bottler.inventory[i] == null || bottler.process[i] == -1) continue;
            float step = (float)bottler.process[i] / 120.0f;
            double d = fill = (double)step >= 0.4 + d0 + d1 * 1.5 ? 1.0 : 0.0;
            if (bottler.predictedOutput[i] != null) {
                if ((double)step >= 0.4 + d0 && (double)step < 0.4 + d0 + d1) {
                    fill = tapShift = ((double)step - 0.4 - d0) / d1;
                } else if ((double)step >= 0.4 + d0 + d1 && (double)step < 0.4 + d0 + d1 * 1.5) {
                    tapShift = 1.0;
                    fill = 1.0;
                } else if ((double)step >= 0.4 + d0 + d1 * 1.5 && (double)step < 0.4 + d0 + d1 * 2.5) {
                    tapShift = 1.0 - ((double)step - 0.4 - d0 - d1 * 1.5) / d1;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)1.0, (double)1.15625, (double)0.5);
            double itemX = 0.0;
            double itemY = 0.0;
            double itemZ = 0.0;
            itemX = -((double)step < 0.18 ? 0.0 : ((double)step < 0.4 ? ((double)step - 0.18) / 0.22 * 0.75 : ((double)step < 0.6 ? 0.75 + ((double)step - 0.4) / 0.2 * 0.8125 : ((double)step < 0.82 ? 1.5625 + ((double)step - 0.6) / 0.22 * 0.75 : 2.3125))));
            itemZ = -((double)step < 0.18 ? (double)step / 0.18 * 0.9 : ((double)step < 0.4 ? 0.9 + ((double)step - 0.18) / 0.22 * 0.7875 : ((double)step < 0.6 ? 1.6875 : ((double)step < 0.82 ? 1.6875 - ((double)step - 0.6) / 0.22 * 0.7875 : (double)(1.0f - step) / 0.18 * 0.9))));
            GL11.glTranslated((double)itemX, (double)itemY, (double)itemZ);
            if (bottler.mirrored) {
                GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            }
            TileRenderBottlingMachine.renderItemToFill(bottler.inventory[i], bottler.predictedOutput[i], (float)fill, (double)step >= 0.71, bottler.getWorldObj(), bottler.facing);
            GL11.glPopMatrix();
        }
        GL11.glTranslated((double)(-shift * tapShift), (double)0.0, (double)0.0);
        Tessellator tes = ClientUtils.tes();
        ClientUtils.bindAtlas(0);
        tes.startDrawingQuads();
        this.model.render(tile, tes, translationMatrix, rotationMatrix, 0, bottler.mirrored, "tap");
        tes.draw();
        GL11.glTranslated((double)(shift * tapShift), (double)0.0, (double)0.0);
        GL11.glPopMatrix();
    }

    static void renderItemToFill(ItemStack empty, ItemStack full, float fill, boolean packaged, World world, int machineRotation) {
        if (empty == null) {
            return;
        }
        if (full != null && MinecraftForgeClient.getItemRenderer((ItemStack)empty, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY) == null && MinecraftForgeClient.getItemRenderer((ItemStack)full, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY) == null && empty.getItemSpriteNumber() == 1 && full.getItemSpriteNumber() == 1) {
            int col;
            double pxFill;
            int h;
            int pass;
            GL11.glPushMatrix();
            ClientUtils.bindAtlas(1);
            GL11.glTranslated((double)0.0, (double)-0.0525, (double)0.010416666666666666);
            GL11.glScalef((float)0.51f, (float)0.51f, (float)0.51f);
            if (fill > 0.0f) {
                for (pass = 0; pass < full.getItem().getRenderPasses(full.getItemDamage()); ++pass) {
                    IIcon iconFull = full.getItem().getIcon(full, pass);
                    h = Math.round(fill * (float)iconFull.getIconHeight());
                    pxFill = (double)h / (double)iconFull.getIconHeight();
                    col = full.getItem().getColorFromItemStack(full, pass);
                    GL11.glColor3f((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f));
                    ClientUtils.renderItemIn2D(iconFull, new double[]{0.0, 1.0, 1.0 - pxFill, 1.0}, iconFull.getIconWidth(), h, 0.0625f);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            if (fill < 1.0f) {
                for (pass = 0; pass < empty.getItem().getRenderPasses(empty.getItemDamage()); ++pass) {
                    IIcon iconEmpty = empty.getItem().getIcon(empty, pass);
                    h = Math.round((1.0f - fill) * (float)iconEmpty.getIconHeight());
                    pxFill = (double)h / (double)iconEmpty.getIconHeight();
                    GL11.glTranslated((double)0.0, (double)(1.0 - pxFill), (double)0.0);
                    col = empty.getItem().getColorFromItemStack(empty, pass);
                    GL11.glColor3f((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f));
                    ClientUtils.renderItemIn2D(iconEmpty, new double[]{0.0, 1.0, 0.0, pxFill}, iconEmpty.getIconWidth(), h, 0.0625f);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslated((double)0.0, (double)(-1.0 - pxFill), (double)0.0);
                }
            }
            GL11.glPopMatrix();
        } else {
            if (!RenderManager.instance.options.fancyGraphics) {
                float rot = machineRotation == 2 ? 180.0f : (machineRotation == 4 ? 90.0f : (machineRotation == 5 ? -90.0f : 0.0f));
                GL11.glRotatef((float)(rot - RenderManager.instance.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, packaged && full != null ? full : empty);
            entityitem.getEntityItem().stackSize = 1;
            entityitem.hoverStart = 0.0f;
            RenderItem.renderInFrame = true;
            RenderManager.instance.renderEntityWithPosYaw((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.renderInFrame = false;
        }
    }
}

