/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class TileRenderMetalPress
extends TileRenderIE {
    ModelIEObj model = new ModelIEObj("immersiveengineering:models/metalPress.obj"){

        @Override
        public IIcon getBlockIcon(String groupName) {
            if (groupName.equalsIgnoreCase("conveyors")) {
                return IEContent.blockMetalDevice.getIcon(0, 11);
            }
            return IEContent.blockMetalMultiblocks.getIcon(0, 13);
        }
    };

    @Override
    public void renderStatic(TileEntity tile, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix) {
        TileEntityMetalPress press = (TileEntityMetalPress)tile;
        translationMatrix.translate(0.5, -1.0, 0.5);
        rotationMatrix.rotate(Math.toRadians(press.facing == 2 ? 180.0 : (press.facing == 4 ? -90.0 : (press.facing == 5 ? 90.0 : 0.0))), 0.0, 1.0, 0.0);
        this.model.render(tile, tes, translationMatrix, rotationMatrix, 0, false, "base", "conveyors");
    }

    @Override
    public void renderDynamic(TileEntity tile, double x, double y, double z, float f) {
        int i;
        TileEntityMetalPress press = (TileEntityMetalPress)tile;
        if (press.pos != 4) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y - 1.0), (double)(z + 0.5));
        GL11.glRotatef((float)(press.facing == 3 ? 180.0f : (press.facing == 4 ? 90.0f : (press.facing == 5 ? -90.0f : 0.0f))), (float)0.0f, (float)1.0f, (float)0.0f);
        float piston = 0.0f;
        float[] shift = new float[press.inventory.length];
        for (i = 0; i < press.inventory.length; ++i) {
            float process = (float)press.process[i] / 120.0f;
            shift[i] = process < 0.4375f ? process / 0.4375f * 0.5f : (process < 0.5625f ? 0.5f : 0.5f + (process - 0.5625f) / 0.4375f * 0.5f);
            if (press.mold == null || !(process >= 0.4375f) || !(process < 0.5625f)) continue;
            piston = process < 0.46875f ? (process - 0.4375f) / 0.03125f : (process < 0.53125f ? 1.0f : 1.0f - (process - 0.53125f) / 0.03125f);
        }
        ClientUtils.bindAtlas(0);
        GL11.glTranslated((double)0.0, (double)(-piston * 0.6875f), (double)0.0);
        ClientUtils.tes().startDrawingQuads();
        this.model.render(tile, ClientUtils.tes(), new Matrix4(), new Matrix4(), 0, false, "piston");
        ClientUtils.tes().draw();
        GL11.glDisable((int)2896);
        if (press.mold != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.875, (double)0.3125);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ClientUtils.bindAtlas(1);
            for (int pass = 0; pass < press.mold.getItem().getRenderPasses(press.mold.getItemDamage()); ++pass) {
                IIcon icon = press.mold.getItem().getIcon(press.mold, pass);
                if (icon == null) continue;
                float scale = 0.625f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                int col = press.mold.getItem().getColorFromItemStack(press.mold, pass);
                GL11.glColor3f((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f));
                ClientUtils.renderItemIn2D(icon, new double[]{0.0, 1.0, 0.0, 1.0}, icon.getIconWidth(), icon.getIconHeight(), 0.0625f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
            }
            GL11.glPopMatrix();
        }
        GL11.glTranslated((double)0.0, (double)(piston * 0.6875f), (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.15, (double)1.46);
        for (i = 0; i < press.inventory.length; ++i) {
            if (press.inventory[i] == null || press.process[i] >= 119 || press.process[i] < 0) continue;
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-2.5 * (double)shift[i]));
            ItemStack stack = press.inventory[i];
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            EntityItem entityitem = new EntityItem(tile.getWorldObj(), 0.0, 0.0, 0.0, stack);
            entityitem.getEntityItem().stackSize = 1;
            entityitem.hoverStart = 0.0f;
            RenderItem.renderInFrame = true;
            RenderManager.instance.renderEntityWithPosYaw((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.renderInFrame = false;
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(2.5 * (double)shift[i]));
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

