/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.energy.IICProxy;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData(String s) {
        super(s);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int[] savedDimensions;
        for (int dim : savedDimensions = nbt.getIntArray("savedDimensions")) {
            NBTTagList connectionList = nbt.getTagList("connectionList" + dim, 10);
            ImmersiveNetHandler.INSTANCE.clearAllConnections(dim);
            for (int i = 0; i < connectionList.tagCount(); ++i) {
                NBTTagCompound conTag = connectionList.getCompoundTagAt(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con == null) continue;
                ImmersiveNetHandler.INSTANCE.addConnection(dim, con.start, con);
            }
        }
        NBTTagList l = nbt.getTagList("iicProxies", 10);
        int max = l.tagCount();
        for (int i = 0; i < max; ++i) {
            ImmersiveNetHandler.INSTANCE.addProxy(IICProxy.readFromNBT(l.getCompoundTagAt(i)));
        }
        EventHandler.validateConnsNextTick = true;
        NBTTagList mineralList = nbt.getTagList("mineralDepletion", 10);
        ExcavatorHandler.mineralCache.clear();
        for (int i = 0; i < mineralList.tagCount(); ++i) {
            NBTTagCompound tag = mineralList.getCompoundTagAt(i);
            DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(tag);
            if (coords == null) continue;
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.MineralWorldInfo.readFromNBT(tag.getCompoundTag("info"));
            ExcavatorHandler.mineralCache.put(coords, info);
        }
        NBTTagList receivedShaderList = nbt.getTagList("receivedShaderList", 10);
        for (int i = 0; i < receivedShaderList.tagCount(); ++i) {
            NBTTagCompound tag = receivedShaderList.getCompoundTagAt(i);
            String player = tag.getString("player");
            ShaderRegistry.receivedShaders.get((Object)player).clear();
            NBTTagList playerReceived = tag.getTagList("received", 8);
            for (int j = 0; j < playerReceived.tagCount(); ++j) {
                String s = playerReceived.getStringTagAt(j);
                if (s == null || s.isEmpty()) continue;
                ShaderRegistry.receivedShaders.put((Object)player, (Object)s);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        Integer[] relDim = ImmersiveNetHandler.INSTANCE.getRelevantDimensions().toArray(new Integer[0]);
        int[] savedDimensions = new int[relDim.length];
        for (int ii = 0; ii < relDim.length; ++ii) {
            savedDimensions[ii] = relDim[ii];
        }
        nbt.setIntArray("savedDimensions", savedDimensions);
        for (int dim : savedDimensions) {
            WorldServer world = MinecraftServer.getServer().worldServerForDimension(dim);
            if (world == null) continue;
            NBTTagList connectionList = new NBTTagList();
            for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                connectionList.appendTag((NBTBase)con.writeToNBT());
            }
            nbt.setTag("connectionList" + dim, (NBTBase)connectionList);
        }
        NBTTagList mineralList = new NBTTagList();
        for (Map.Entry<DimensionChunkCoords, ExcavatorHandler.MineralWorldInfo> e : ExcavatorHandler.mineralCache.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            NBTTagCompound tag = e.getKey().writeToNBT();
            tag.setTag("info", (NBTBase)e.getValue().writeToNBT());
            mineralList.appendTag((NBTBase)tag);
        }
        nbt.setTag("mineralDepletion", (NBTBase)mineralList);
        NBTTagList receivedShaderList = new NBTTagList();
        for (String player : ShaderRegistry.receivedShaders.keySet()) {
            if (player == null || player.isEmpty()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setString("player", player);
            NBTTagList playerReceived = new NBTTagList();
            for (String shader : ShaderRegistry.receivedShaders.get((Object)player)) {
                if (shader == null || shader.isEmpty()) continue;
                playerReceived.appendTag((NBTBase)new NBTTagString(shader));
            }
            tag.setTag("received", (NBTBase)playerReceived);
            receivedShaderList.appendTag((NBTBase)tag);
        }
        nbt.setTag("receivedShaderList", (NBTBase)receivedShaderList);
        NBTTagList iicProxies = new NBTTagList();
        for (Map.Entry<DimensionBlockPos, IICProxy> prox : ImmersiveNetHandler.INSTANCE.proxies.entrySet()) {
            NBTTagCompound c = prox.getValue().writeToNBT();
            iicProxies.appendTag((NBTBase)c);
        }
        nbt.setTag("iicProxies", (NBTBase)iicProxies);
    }

    public static void setDirty(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && INSTANCE != null) {
            INSTANCE.markDirty();
        }
    }

    public static void setInstance(int dimension, IESaveData in) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INSTANCE = in;
        }
    }
}

