/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIESlabs;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockIESlabs
extends BlockIEBase {
    String iconKey;

    public BlockIESlabs(String name, String iconKey, Material material, String ... subNames) {
        super(name, material, 1, ItemBlockIESlabs.class, subNames);
        this.iconKey = iconKey;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        for (int i = 0; i < this.subNames.length; ++i) {
            this.icons[i][0] = iconRegister.registerIcon("immersiveengineering:" + this.iconKey + this.subNames[i]);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityIESlab && !player.capabilities.isCreativeMode && willHarvest && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            EntityItem drop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack((Block)this, ((TileEntityIESlab)te).slabType == 2 ? 2 : 1, world.getBlockMetadata(x, y, z)));
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)drop);
            }
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                return side == ForgeDirection.DOWN;
            }
            if (type == 1) {
                return side == ForgeDirection.UP;
            }
        }
        return true;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, aabb, list, ent);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            } else if (type == 1) {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityIESlab();
    }

    @Override
    public boolean allowHammerHarvest(int metadata) {
        return false;
    }
}

