/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockIESlabs
extends ItemBlockIEBase {
    public ItemBlockIESlabs(Block b) {
        super(b);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.getBlock(x, y, z);
        int x0 = x;
        int y0 = y;
        int z0 = z;
        int x1 = x + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int y1 = y + (side == 0 ? -1 : (side == 1 ? 1 : 0));
        int z1 = z + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        if (block == Blocks.snow_layer && (world.getBlockMetadata(x, y, z) & 7) < 1) {
            side = 1;
        } else if (block != Blocks.vine && block != Blocks.tallgrass && block != Blocks.deadbush && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        TileEntityIESlab stackSlab = null;
        if ((side == 0 || side == 1) && this.field_150939_a.equals(world.getBlock(x0, y0, z0)) && world.getBlockMetadata(x0, y0, z0) == stack.getItemDamage()) {
            TileEntity te = world.getTileEntity(x0, y0, z0);
            if (te instanceof TileEntityIESlab && ((TileEntityIESlab)te).slabType + side == 1) {
                stackSlab = (TileEntityIESlab)te;
            }
        } else if (this.field_150939_a.equals(world.getBlock(x1, y1, z1)) && world.getBlockMetadata(x1, y1, z1) == stack.getItemDamage()) {
            int type;
            TileEntity te = world.getTileEntity(x1, y1, z1);
            if (te instanceof TileEntityIESlab && ((type = ((TileEntityIESlab)te).slabType) == 0 && (side == 0 || (double)hitY >= 0.5) || type == 1 && (side == 1 || (double)hitY <= 0.5))) {
                stackSlab = (TileEntityIESlab)te;
            }
        } else {
            return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (stackSlab != null) {
            stackSlab.slabType = 2;
            world.markBlockForUpdate(stackSlab.xCoord, stackSlab.yCoord, stackSlab.zCoord);
            world.playSoundEffect((double)stackSlab.xCoord + 0.5, (double)stackSlab.yCoord + 0.5, (double)stackSlab.zCoord + 0.5, this.field_150939_a.stepSound.func_150496_b(), (this.field_150939_a.stepSound.getVolume() + 1.0f) / 2.0f, this.field_150939_a.stepSound.getPitch() * 0.8f);
            --stack.stackSize;
            return true;
        }
        return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        TileEntity tileEntity;
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, meta);
        if (ret && (tileEntity = world.getTileEntity(x, y, z)) instanceof TileEntityIESlab) {
            ((TileEntityIESlab)tileEntity).slabType = side == 0 || side != 1 && (double)hitY >= 0.5 ? 1 : 0;
        }
        return ret;
    }
}

