/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IICProxy;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public abstract class TileEntityImmersiveConnectable
extends TileEntityIEBase
implements IImmersiveConnectable {
    protected WireType limitType = null;

    protected boolean canTakeLV() {
        return false;
    }

    protected boolean canTakeMV() {
        return false;
    }

    protected boolean canTakeHV() {
        return false;
    }

    public void invalidate() {
        super.invalidate();
        if (!(this.worldObj == null || this.worldObj.isRemote && Minecraft.getMinecraft().isSingleplayer())) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(this), this.worldObj, !this.worldObj.isRemote);
        }
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (cableType == WireType.ELECTRUM && !this.canTakeMV()) {
            return false;
        }
        if (cableType == WireType.COPPER && !this.canTakeLV()) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_ROPE) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_STEEL) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        this.limitType = cableType;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type = connection != null ? connection.cableType : null;
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.worldObj, Utils.toCC(this));
        if (!(outputs != null && outputs.size() != 0 || type != this.limitType && type != null)) {
            this.limitType = null;
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.worldObj.isRemote) {
            ImmersiveNetHandler.INSTANCE.setProxy(new DimensionBlockPos(this), new IICProxy(this));
        }
    }

    public void validate() {
        super.validate();
        ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
    }

    @Override
    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        if (this.worldObj != null && !this.worldObj.isRemote) {
            NBTTagList connectionList = new NBTTagList();
            Set<ImmersiveNetHandler.Connection> conL = ImmersiveNetHandler.INSTANCE.getConnections(this.worldObj, Utils.toCC(this));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.appendTag((NBTBase)con.writeToNBT());
                }
            }
            nbttagcompound.setTag("connectionList", (NBTBase)connectionList);
        }
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 3, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.readFromNBT(nbt);
        if (this.worldObj != null && this.worldObj.isRemote && !Minecraft.getMinecraft().isSingleplayer()) {
            NBTTagList connectionList = nbt.getTagList("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC(this), this.worldObj);
            for (int i = 0; i < connectionList.tagCount(); ++i) {
                NBTTagCompound conTag = connectionList.getCompoundTagAt(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.worldObj, Utils.toCC(this), con);
                    continue;
                }
                IELogger.error("CLIENT read connection as null");
            }
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == -1 || id == 255) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            if (nbt.hasKey("limitType")) {
                this.limitType = ApiUtils.getWireTypeFromNBT(nbt, "limitType");
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error reading NBT. You shoudl probably report this.");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            if (this.limitType != null) {
                nbt.setString("limitType", this.limitType.getUniqueName());
            }
            if (this.worldObj != null) {
                nbt.setIntArray("prevPos", new int[]{this.worldObj.provider.dimensionId, this.xCoord, this.yCoord, this.zCoord});
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error writing NBT. You should probably report this.");
        }
    }
}

