/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class TileEntityBreakerSwitch
extends TileEntityImmersiveConnectable {
    public int sideAttached = 0;
    public int facing = 2;
    public int wires = 0;
    public boolean active = false;
    public boolean inverted = false;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return false;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return this.active;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType != null && !cableType.isEnergyWire()) {
            return false;
        }
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (this.wires >= 2) {
            return false;
        }
        return this.limitType == null || cableType == this.limitType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        if (this.limitType == null) {
            this.limitType = cableType;
        }
        ++this.wires;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        this.wires = type == null ? 0 : --this.wires;
        if (this.wires <= 0) {
            this.limitType = null;
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setInteger("sideAttached", this.sideAttached);
        nbt.setInteger("wires", this.wires);
        nbt.setBoolean("active", this.active);
        nbt.setBoolean("inverted", this.inverted);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.sideAttached = nbt.getInteger("sideAttached");
        this.wires = nbt.getInteger("wires");
        this.active = nbt.getBoolean("active");
        this.inverted = nbt.getBoolean("inverted");
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        return Vec3.createVectorHelper((double)0.5, (double)0.5, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double h;
        int xDif;
        ChunkCoordinates here = Utils.toCC(this);
        if (this.sideAttached == 0) {
            int zDif;
            int xDif2;
            int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posX - this.xCoord : (xDif2 = con.end.equals((Object)here) && con.start != null ? con.start.posX - this.xCoord : 0));
            int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posZ - this.zCoord : (zDif = con.end.equals((Object)here) && con.start != null ? con.start.posZ - this.zCoord : 0));
            return Vec3.createVectorHelper((double)(this.facing == 4 ? 0.125 : (this.facing == 5 ? 0.875 : (xDif2 < 0 ? 0.25 : 0.75))), (double)0.5, (double)(this.facing == 2 ? 0.125 : (this.facing == 3 ? 0.875 : (zDif < 0 ? 0.25 : 0.75))));
        }
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posX - this.xCoord : (xDif = con.end.equals((Object)here) && con.start != null ? con.start.posX - this.xCoord : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posZ - this.zCoord : (con.end.equals((Object)here) && con.start != null ? con.start.posZ - this.zCoord : 0));
        double d = h = this.sideAttached == 1 ? 0.125 : 0.875;
        if (this.facing > 3) {
            return Vec3.createVectorHelper((double)0.5, (double)h, (double)(zDif > 0 ? 0.75 : 0.25));
        }
        return Vec3.createVectorHelper((double)(xDif > 0 ? 0.75 : 0.25), (double)h, (double)0.5);
    }

    public void toggle() {
        this.active = !this.active;
        ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), this.active ? 1 : 0, 0);
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (super.receiveClientEvent(id, arg)) {
            return true;
        }
        this.active = id == 1;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return true;
    }
}

