/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityBucketWheel
extends TileEntityMultiblockPart {
    public int facing = 2;
    public float rotation = 0.0f;
    public ItemStack[] digStacks = new ItemStack[8];
    public boolean active = false;
    public ItemStack particleStack;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = this.pos < 0 ? null : MultiblockBucketWheel.instance.getStructureManual()[this.pos / 7][this.pos % 7][0];
        return s != null ? s.copy() : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        float nbtRot = nbt.getFloat("rotation");
        this.rotation = Math.abs(nbtRot - this.rotation) > 5.0f * (float)Config.getDouble("excavator_speed") ? nbtRot : this.rotation;
        this.digStacks = Utils.readInventory(nbt.getTagList("digStacks", 10), 8);
        this.active = nbt.getBoolean("active");
        this.particleStack = nbt.hasKey("particleStack") ? ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("particleStack")) : null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setFloat("rotation", this.rotation);
        nbt.setTag("digStacks", (NBTBase)Utils.writeInventory(this.digStacks));
        nbt.setBoolean("active", this.active);
        if (this.particleStack != null) {
            nbt.setTag("particleStack", (NBTBase)this.particleStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 24) {
            return;
        }
        if (this.active) {
            this.rotation += (float)Config.getDouble("excavator_speed");
            this.rotation %= 360.0f;
        }
        if (this.worldObj.isRemote && this.particleStack != null) {
            ImmersiveEngineering.proxy.spawnBucketWheelFX(this, this.particleStack);
            this.particleStack = null;
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            for (int w = -3; w <= 3; ++w) {
                for (int h = -3; h <= 3; ++h) {
                    int xx = f == 3 ? -w : (f == 2 ? w : 0);
                    int yy = h;
                    int zz = f == 5 ? -w : (f == 4 ? w : 0);
                    ItemStack s = null;
                    TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                    if (te instanceof TileEntityBucketWheel) {
                        s = ((TileEntityBucketWheel)te).getOriginalBlock();
                        ((TileEntityBucketWheel)te).formed = false;
                    }
                    if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                    if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                        this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                        continue;
                    }
                    if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                        this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                    }
                    this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                }
            }
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 24 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing < 4 ? 3 : 0)), (double)(this.yCoord - 3), (double)(this.zCoord - (this.facing > 3 ? 3 : 0)), (double)(this.xCoord + (this.facing < 4 ? 4 : 1)), (double)(this.yCoord + 4), (double)(this.zCoord + (this.facing > 3 ? 4 : 1))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 3 || this.pos == 9 || this.pos == 11) {
            return new float[]{0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos == 45 || this.pos == 37 || this.pos == 39) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f};
        }
        if (this.pos == 21) {
            return new float[]{this.facing == 2 ? 0.25f : 0.0f, 0.0f, this.facing == 4 ? 0.25f : 0.0f, this.facing == 3 ? 0.75f : 1.0f, 1.0f, this.facing == 5 ? 0.75f : 1.0f};
        }
        if (this.pos == 27) {
            return new float[]{this.facing == 3 ? 0.25f : 0.0f, 0.0f, this.facing == 5 ? 0.25f : 0.0f, this.facing == 2 ? 0.75f : 1.0f, 1.0f, this.facing == 4 ? 0.75f : 1.0f};
        }
        if (this.pos == 15 || this.pos == 29) {
            return new float[]{this.facing == 2 ? 0.25f : 0.0f, 0.0f, this.facing == 4 ? 0.25f : 0.0f, this.facing == 3 ? 0.75f : 1.0f, 1.0f, this.facing == 5 ? 0.75f : 1.0f};
        }
        if (this.pos == 19 || this.pos == 33) {
            return new float[]{this.facing == 3 ? 0.25f : 0.0f, 0.0f, this.facing == 5 ? 0.25f : 0.0f, this.facing == 2 ? 0.75f : 1.0f, 1.0f, this.facing == 4 ? 0.75f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public TileEntityBucketWheel master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityBucketWheel ? (TileEntityBucketWheel)te : null;
    }
}

