/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCapacitorLV;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCapacitorCreative
extends TileEntityCapacitorLV {
    public TileEntityCapacitorCreative() {
        for (int i = 0; i < this.sideConfig.length; ++i) {
            this.sideConfig[i] = 1;
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.worldObj.isRemote || from.ordinal() >= this.sideConfig.length || this.sideConfig[from.ordinal()] != 0) {
            return 0;
        }
        return maxReceive;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.worldObj.isRemote || from.ordinal() >= this.sideConfig.length || this.sideConfig[from.ordinal()] != 1) {
            return 0;
        }
        return maxExtract;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void transferEnergy(int side) {
        TileEntity te;
        if (this.sideConfig[side] != 1) {
            return;
        }
        ForgeDirection to = ForgeDirection.getOrientation((int)side);
        if (this.worldObj.blockExists(this.xCoord + to.offsetX, this.yCoord + to.offsetY, this.zCoord + to.offsetZ)) {
            // empty if block
        }
        if ((te = this.worldObj.getTileEntity(this.xCoord + to.offsetX, this.yCoord + to.offsetY, this.zCoord + to.offsetZ)) instanceof IEnergyReceiver) {
            ((IEnergyReceiver)te).receiveEnergy(to.getOpposite(), Integer.MAX_VALUE, false);
        }
    }
}

