/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCapacitorLV
extends TileEntityIEBase
implements IEnergyHandler,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{-1, 0, -1, -1, -1, -1};
    EnergyStorage energyStorage = new EnergyStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    public int comparatorOutput = 0;

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
            if (this.worldObj.getTotalWorldTime() % 32L == (long)((this.xCoord ^ this.zCoord) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(int side) {
        if (this.sideConfig[side] != 1) {
            return;
        }
        ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
        TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        if (tileEntity instanceof IEnergyReceiver) {
            this.energyStorage.modifyEnergyStored(-((IEnergyReceiver)tileEntity).receiveEnergy(fd.getOpposite(), Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored()), false));
        }
    }

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    public int getMaxStorage() {
        return Config.getInt("capacitorLV_storage");
    }

    public int getMaxInput() {
        return Config.getInt("capacitorLV_input");
    }

    public int getMaxOutput() {
        return Config.getInt("capacitorLV_output");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 6) {
            this.sideConfig = new int[6];
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection fd) {
        return fd.ordinal() < this.sideConfig.length && this.sideConfig[fd.ordinal()] >= 0;
    }

    @Override
    public int extractEnergy(ForgeDirection fd, int amount, boolean simulate) {
        if (this.worldObj.isRemote || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 1) {
            return 0;
        }
        int r = this.energyStorage.extractEnergy(amount, simulate);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return r;
    }

    @Override
    public int getEnergyStored(ForgeDirection fd) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection fd) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(ForgeDirection fd, int amount, boolean simulate) {
        if (this.worldObj.isRemote || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 0) {
            return 0;
        }
        int r = this.energyStorage.receiveEnergy(amount, simulate);
        return r;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (hammer && Config.getBoolean("colourblindSupport")) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit)];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, ForgeDirection.OPPOSITES[mop.sideHit])];
            return new String[]{StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.blockSide.facing") + ": " + StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.blockSide.connectEnergy." + i)), StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.blockSide.opposite") + ": " + StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.blockSide.connectEnergy." + j))};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }
}

