/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import blusunrize.immersiveengineering.common.util.compat.ModCompatability;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChargingStation
extends TileEntityIEBase
implements IEnergyReceiver,
IInventory {
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(1024, Config.getInt("charger_consumption")));
    public int facing = 2;
    public ItemStack inventory;
    private boolean charging = false;
    public int comparatorOutput = 0;

    public void updateEntity() {
        if (this.inventory != null && (this.inventory.getItem() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(this.inventory))) {
            int max;
            if (this.worldObj.isRemote && this.charging) {
                float charge = 0.0f;
                if (this.inventory.getItem() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.getItem();
                    int max2 = container.getMaxEnergyStored(this.inventory);
                    if (max2 > 0) {
                        charge = (float)container.getEnergyStored(this.inventory) / (float)max2;
                    }
                } else {
                    double max3 = IC2Helper.getMaxItemCharge(this.inventory);
                    if (max3 > 0.0) {
                        charge = (float)(IC2Helper.getCurrentItemCharge(this.inventory) / max3);
                    }
                }
                max = 3;
                for (int i = 0; i < max; ++i) {
                    long time = this.worldObj.getTotalWorldTime();
                    if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                    int shift = i - 1;
                    double x = (double)this.xCoord + 0.5 + (this.facing == 4 ? -0.46875 : (this.facing == 5 ? 0.46875 : (this.facing == 2 ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    double y = (double)this.yCoord + 0.25;
                    double z = (double)this.zCoord + 0.5 + (this.facing == 2 ? -0.46875 : (this.facing == 3 ? 0.46875 : (this.facing == 5 ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.worldObj, x, y, z, 0.25, 0.25, 0.25, 0.5f, 1.0f - charge, charge, 0.0f);
                }
            } else if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    return;
                }
                if (this.inventory.getItem() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.getItem();
                    max = container.getMaxEnergyStored(this.inventory);
                    int space = max - container.getEnergyStored(this.inventory);
                    if (max > 0 && space > 0) {
                        int energyDecNew;
                        int energyDec = 10 * container.getEnergyStored(this.inventory) / max;
                        int insert = Math.min(space, Config.getInt("charger_consumption"));
                        int accepted = Math.min(container.receiveEnergy(this.inventory, insert, true), this.energyStorage.extractEnergy(insert, true));
                        if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                            container.receiveEnergy(this.inventory, accepted, false);
                        }
                        if (energyDec != (energyDecNew = 10 * container.getEnergyStored(this.inventory) / max)) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                    }
                } else {
                    double max4 = IC2Helper.getMaxItemCharge(this.inventory);
                    double space = max4 - IC2Helper.getCurrentItemCharge(this.inventory);
                    if (max4 > 0.0 && space > 0.0) {
                        int energyDecNew;
                        int energyDec = (int)(10.0 * IC2Helper.getCurrentItemCharge(this.inventory) / max4);
                        double insert = Math.min(space, ModCompatability.convertRFtoEU(Config.getInt("charger_consumption"), 5));
                        double accepted = IC2Helper.chargeItem(this.inventory, insert, true);
                        int rfAccepted = this.energyStorage.extractEnergy(ModCompatability.convertEUtoRF(accepted), false);
                        if (rfAccepted > 0) {
                            IC2Helper.chargeItem(this.inventory, ModCompatability.convertRFtoEU(rfAccepted, 5), false);
                        }
                        if (energyDec != (energyDecNew = (int)(10.0 * IC2Helper.getCurrentItemCharge(this.inventory) / max4))) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (!this.worldObj.isRemote && this.worldObj.getTotalWorldTime() % 32L == (long)((this.xCoord ^ this.zCoord) & 0x1F)) {
            int i;
            float charge = 0.0f;
            if (this.inventory != null && (this.inventory.getItem() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(this.inventory))) {
                if (this.inventory.getItem() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.getItem();
                    charge = (float)container.getEnergyStored(this.inventory) / (float)container.getMaxEnergyStored(this.inventory);
                } else {
                    charge = (float)(IC2Helper.getCurrentItemCharge(this.inventory) / IC2Helper.getMaxItemCharge(this.inventory));
                }
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.facing = nbt.getInteger("facing");
        this.inventory = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("inventory"));
        this.charging = nbt.getBoolean("charging");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.setInteger("facing", this.facing);
        nbt.setBoolean("charging", this.charging);
        if (this.inventory != null) {
            nbt.setTag("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN || from != null && from.getOpposite().ordinal() == this.facing;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        this.markDirty();
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
    }

    public String getInventoryName() {
        return "IEChargingStation";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return stack != null && stack.getItem() instanceof IEnergyContainerItem;
    }
}

