/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class TileEntityEnergyMeter
extends TileEntityImmersiveConnectable {
    public int facing = 3;
    public int lastEnergyPassed = 0;
    public ArrayList<Integer> lastPackets = new ArrayList(25);
    public boolean dummy = false;
    private int maxTransfer = -1;
    public int compVal = -1;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity() {
        if (this.dummy || this.worldObj.isRemote) {
            return;
        }
        ArrayList<Integer> arrayList = this.lastPackets;
        synchronized (arrayList) {
            this.lastPackets.add(this.lastEnergyPassed);
            if (this.lastPackets.size() > 20) {
                this.lastPackets.remove(0);
            }
            if ((this.worldObj.getTotalWorldTime() & 0x1FL) == (long)((this.xCoord ^ this.zCoord) & 0x1F) || this.compVal < 0) {
                this.updateComparatorValues();
            }
        }
        this.lastEnergyPassed = 0;
    }

    private void updateComparatorValues() {
        if (this.maxTransfer < 0) {
            Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.worldObj, Utils.toCC(this));
            if (conns == null) {
                return;
            }
            this.maxTransfer = 0;
            for (ImmersiveNetHandler.Connection c : conns) {
                this.maxTransfer += c.cableType.getTransferRate();
            }
        }
        float percentage = (float)(this.getAveragePower() * 2) / (float)this.maxTransfer;
        int oldComp = this.compVal;
        this.compVal = (int)Math.min(Math.ceil(15.0f * percentage), 15.0);
        if (oldComp != this.compVal) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            if (!(te instanceof TileEntityEnergyMeter)) {
                return;
            }
            ((TileEntityEnergyMeter)te).compVal = this.compVal;
            this.worldObj.func_147453_f(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }
    }

    @Override
    public boolean canConnect() {
        return !this.dummy;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
        this.lastEnergyPassed += amount;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (this.dummy) {
            TileEntity above = this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord);
            if (above instanceof TileEntityEnergyMeter) {
                return ((TileEntityEnergyMeter)above).canConnectCable(cableType, target);
            }
            return false;
        }
        return super.canConnectCable(cableType, target);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        if (this.dummy) {
            TileEntity above = this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord);
            if (above instanceof TileEntityEnergyMeter) {
                ((TileEntityEnergyMeter)above).connectCable(cableType, target);
            }
        } else {
            super.connectCable(cableType, target);
            if (!this.worldObj.isRemote) {
                this.maxTransfer += cableType.getTransferRate();
            }
        }
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        if (!this.worldObj.isRemote) {
            this.maxTransfer = connection == null ? 0 : (this.maxTransfer -= connection.cableType.getTransferRate());
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setBoolean("dummy", this.dummy);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.dummy = nbt.getBoolean("dummy");
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = ((TileEntity)link).xCoord - this.xCoord;
        int zDif = ((TileEntity)link).zCoord - this.zCoord;
        if (this.facing > 3) {
            return Vec3.createVectorHelper((double)0.5, (double)0.4375, (double)(zDif > 0 ? 0.8125 : 0.1875));
        }
        return Vec3.createVectorHelper((double)(xDif > 0 ? 0.8125 : 0.1875), (double)0.4375, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posX - this.xCoord : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posX - this.xCoord : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posZ - this.zCoord : (zDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posZ - this.zCoord : 0));
        if (this.facing > 3) {
            return Vec3.createVectorHelper((double)0.5, (double)0.4375, (double)(zDif > 0 ? 0.8125 : 0.1875));
        }
        return Vec3.createVectorHelper((double)(xDif > 0 ? 0.8125 : 0.1875), (double)0.4375, (double)0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        TileEntityEnergyMeter te = this;
        if (te.dummy) {
            TileEntity tmp = this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord);
            if (!(tmp instanceof TileEntityEnergyMeter)) {
                return -1;
            }
            te = (TileEntityEnergyMeter)tmp;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        int sum = 0;
        ArrayList<Integer> arrayList = te.lastPackets;
        synchronized (arrayList) {
            for (int transfer : te.lastPackets) {
                sum += transfer;
            }
        }
        return sum / te.lastPackets.size();
    }
}

