/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavator;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class TileEntityExcavator
extends TileEntityMultiblockPart
implements IEnergyReceiver {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(64000);
    public boolean active = false;
    public boolean computerControlled;
    public boolean computerOn;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        int h = this.pos % 9 / 3;
        int l = this.pos / 9;
        int w = this.pos % 3;
        ItemStack s = MultiblockExcavator.instance.getStructureManual()[h][5 - l][w];
        return s != null ? s.copy() : null;
    }

    @Override
    public TileEntityExcavator master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityExcavator ? (TileEntityExcavator)te : null;
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 4) {
            return;
        }
        int[] wheelAxis = new int[]{this.xCoord + (this.facing == 5 ? -4 : (this.facing == 4 ? 4 : 0)), this.yCoord, this.zCoord + (this.facing == 3 ? -4 : (this.facing == 2 ? 4 : 0))};
        int ff = ForgeDirection.ROTATION_MATRIX[this.facing][1];
        float rot = 0.0f;
        int target = -1;
        TileEntityBucketWheel wheel = null;
        TileEntity center = this.worldObj.getTileEntity(wheelAxis[0], wheelAxis[1], wheelAxis[2]);
        if (!this.worldObj.isRemote) {
            boolean enabled;
            if (center instanceof TileEntityBucketWheel) {
                if (((TileEntityBucketWheel)center).facing == ff) {
                    wheel = (TileEntityBucketWheel)center;
                    if (this.active != wheel.active) {
                        this.worldObj.addBlockEvent(wheel.xCoord, wheel.yCoord, wheel.zCoord, wheel.getBlockType(), 0, this.active ? 1 : 0);
                    }
                    if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                        target = Math.round(rot / 360.0f * 8.0f) % 8;
                    }
                }
                if (((TileEntityBucketWheel)center).facing != ff || ((TileEntityBucketWheel)center).mirrored != this.mirrored) {
                    for (int h = -3; h <= 3; ++h) {
                        for (int w = -3; w <= 3; ++w) {
                            TileEntity te = this.worldObj.getTileEntity(wheelAxis[0] + (this.facing > 3 ? w : 0), wheelAxis[1] + h, wheelAxis[2] + (this.facing < 4 ? w : 0));
                            if (!(te instanceof TileEntityBucketWheel)) continue;
                            ((TileEntityBucketWheel)te).facing = ff;
                            ((TileEntityBucketWheel)te).mirrored = this.mirrored;
                            te.markDirty();
                            this.worldObj.markBlockForUpdate(te.xCoord, te.yCoord, te.zCoord);
                        }
                    }
                }
            }
            boolean update = false;
            ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.worldObj, wheelAxis[0] >> 4, wheelAxis[2] >> 4);
            if (this.computerControlled) {
                enabled = this.computerOn;
            } else {
                boolean bl = enabled = !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0)) * (this.mirrored ? -1 : 1), this.yCoord, this.zCoord + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : 0)) * (this.mirrored ? -1 : 1));
            }
            if (wheel != null && enabled) {
                int consumed = Config.getInt("excavator_consumption");
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    update = true;
                    if (target >= 0 && target < 8) {
                        if (wheel.digStacks[(target + 4) % 8] == null) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            if (blocking != null) {
                                wheel.digStacks[(target + 4) % 8] = blocking;
                                wheel.markDirty();
                                this.worldObj.markBlockForUpdate(wheel.xCoord, wheel.yCoord, wheel.zCoord);
                            } else if (!(mineral == null || this.worldObj.isAirBlock(wheel.xCoord + (this.facing == 5 ? 2 : (this.facing == 4 ? -2 : 0)), wheel.yCoord - 5, wheel.zCoord + (this.facing == 3 ? 2 : (this.facing == 2 ? -2 : 0))) || this.worldObj.isAirBlock(wheel.xCoord + (this.facing == 5 ? -2 : (this.facing == 4 ? 2 : 0)), wheel.yCoord - 5, wheel.zCoord + (this.facing == 3 ? -2 : (this.facing == 2 ? 2 : 0))) || this.worldObj.isAirBlock(wheel.xCoord + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 0)), wheel.yCoord - 5, wheel.zCoord + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 0))) || this.worldObj.isAirBlock(wheel.xCoord + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 0)), wheel.yCoord - 5, wheel.zCoord + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0))) || this.worldObj.isAirBlock(wheel.xCoord, wheel.yCoord - 5, wheel.zCoord))) {
                                ItemStack ore = mineral.getRandomOre(this.worldObj.rand);
                                float configChance = this.worldObj.rand.nextFloat();
                                float failChance = this.worldObj.rand.nextFloat();
                                if (ore != null && (double)configChance > Config.getDouble("excavator_chance") && failChance > mineral.failChance) {
                                    wheel.digStacks[(target + 4) % 8] = ore;
                                    wheel.markDirty();
                                    this.worldObj.markBlockForUpdate(wheel.xCoord, wheel.yCoord, wheel.zCoord);
                                }
                                ExcavatorHandler.depleteMinerals(this.worldObj, wheelAxis[0] >> 4, wheelAxis[2] >> 4);
                            }
                        }
                        if (wheel.digStacks[target] != null) {
                            this.outputItem(wheel.digStacks[target].copy());
                            Block b = Block.getBlockFromItem((Item)wheel.digStacks[target].getItem());
                            if (b != null && b != Blocks.air) {
                                wheel.particleStack = wheel.digStacks[target].copy();
                            }
                            wheel.digStacks[target] = null;
                            wheel.markDirty();
                            this.worldObj.markBlockForUpdate(wheel.xCoord, wheel.yCoord, wheel.zCoord);
                        }
                    }
                } else {
                    this.active = false;
                    update = true;
                }
            } else if (this.active) {
                this.active = false;
                update = true;
            }
            if (update) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public void outputItem(ItemStack stack) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord, this.zCoord + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[this.facing])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[this.facing]);
        }
        if (stack != null) {
            EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)fd.offsetX, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5 + (double)fd.offsetZ, stack.copy());
            ei.motionX = 0.075f * (float)fd.offsetX;
            ei.motionY = 0.025000000372529;
            ei.motionZ = 0.075f * (float)fd.offsetZ;
            this.worldObj.spawnEntityInWorld((Entity)ei);
        }
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).getAccessibleSlotsFromSide(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).getSizeInventory() > 0;
    }

    ItemStack digBlocksInTheWay(TileEntityBucketWheel wheel) {
        ItemStack s = this.digBlock(wheel.xCoord, wheel.yCoord - 4, wheel.zCoord);
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 0)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? 2 : (this.facing == 4 ? -2 : 0)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? 2 : (this.facing == 2 ? -2 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 0)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? -2 : (this.facing == 4 ? 2 : 0)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? -2 : (this.facing == 2 ? 2 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 1)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : -1)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : -1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing < 4 ? 1 : 0), wheel.yCoord - 4, wheel.zCoord + (this.facing > 3 ? 1 : 0));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing < 4 ? -1 : 0), wheel.yCoord - 4, wheel.zCoord + (this.facing > 3 ? -1 : 0));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 1)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.xCoord + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : -1)), wheel.yCoord - 4, wheel.zCoord + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : -1)));
        if (s != null) {
            return s;
        }
        return null;
    }

    ItemStack digBlock(int x, int y, int z) {
        if (!(this.worldObj instanceof WorldServer)) {
            return null;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((WorldServer)this.worldObj);
        Block block = this.worldObj.getBlock(x, y, z);
        int meta = this.worldObj.getBlockMetadata(x, y, z);
        if (block != null && !this.worldObj.isAirBlock(x, y, z) && block.getPlayerRelativeBlockHardness((EntityPlayer)fakePlayer, this.worldObj, x, y, z) != 0.0f) {
            if (!block.canHarvestBlock((EntityPlayer)fakePlayer, meta)) {
                return null;
            }
            block.onBlockHarvested(this.worldObj, x, y, z, meta, (EntityPlayer)fakePlayer);
            if (block.removedByPlayer(this.worldObj, (EntityPlayer)fakePlayer, x, y, z, true)) {
                block.onBlockDestroyedByPlayer(this.worldObj, x, y, z, meta);
                if (block.canSilkHarvest(this.worldObj, (EntityPlayer)fakePlayer, x, y, z, meta)) {
                    ItemStack itemstack;
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    Item bitem = Item.getItemFromBlock((Block)block);
                    if (bitem == null) {
                        return null;
                    }
                    int m = 0;
                    if (bitem != null && bitem.getHasSubtypes()) {
                        m = meta;
                    }
                    if ((itemstack = new ItemStack(bitem, 1, m)) != null) {
                        items.add(itemstack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(items, (World)this.worldObj, (Block)block, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    for (int i = 0; i < items.size(); ++i) {
                        if (i == 0) continue;
                        EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, ((ItemStack)items.get(i)).copy());
                        this.worldObj.spawnEntityInWorld((Entity)ei);
                    }
                    this.worldObj.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)block) + (meta << 12));
                    if (items.size() > 0) {
                        return (ItemStack)items.get(0);
                    }
                } else {
                    block.harvestBlock(this.worldObj, (EntityPlayer)fakePlayer, x, y, z, meta);
                    this.worldObj.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)block) + (meta << 12));
                }
            }
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.active = nbt.getBoolean("active");
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setBoolean("active", this.active);
        this.energyStorage.writeToNBT(nbt);
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int startZ;
            int startY;
            int startX;
            int[] wheelAxis;
            TileEntity center;
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            if (this.mirrored) {
                iw = -iw;
            }
            if ((center = this.worldObj.getTileEntity((wheelAxis = new int[]{(startX = this.xCoord - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)))) + (this.facing == 5 ? -4 : (this.facing == 4 ? 4 : 0)), startY = this.yCoord - ih, (startZ = this.zCoord - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)))) + (this.facing == 3 ? -4 : (this.facing == 2 ? 4 : 0))})[0], wheelAxis[1], wheelAxis[2])) instanceof TileEntityBucketWheel) {
                ((TileEntityBucketWheel)center).active = false;
                center.markDirty();
                this.worldObj.markBlockForUpdate(wheelAxis[0], wheelAxis[1], wheelAxis[2]);
            }
            for (int l = 0; l < 6; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int ww;
                        int n = ww = this.mirrored ? -w : w;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -ww : ww));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -ww : ww));
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityExcavator) {
                            s = ((TileEntityExcavator)te).getOriginalBlock();
                            ((TileEntityExcavator)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && (this.pos == 11 || this.pos == 14 || this.pos == 17) && from != ForgeDirection.UP && from != ForgeDirection.DOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityExcavator master = this.master();
        if (this.formed && master != null && (this.pos == 11 || this.pos == 14 || this.pos == 17) && from != ForgeDirection.UP && from != ForgeDirection.DOWN) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityExcavator master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityExcavator master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing == 5 ? 5 : (this.facing == 4 ? 0 : 1))), (double)(this.yCoord - 1), (double)(this.zCoord - (this.facing == 3 ? 5 : (this.facing == 2 ? 0 : 1))), (double)(this.xCoord + (this.facing == 4 ? 6 : (this.facing == 5 ? 1 : 2))), (double)(this.yCoord + 2), (double)(this.zCoord + (this.facing == 2 ? 6 : (this.facing == 3 ? 1 : 2)))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        int fl = this.facing;
        int fw = this.facing;
        if (this.mirrored) {
            fw = ForgeDirection.OPPOSITES[fw];
        }
        if (this.pos == 42) {
            return new float[]{fl == 4 || fl == 5 ? -0.5f : 0.0f, 0.0f, fl == 2 || fl == 3 ? -0.5f : 0.0f, fl == 4 || fl == 5 ? 1.5f : 1.0f, 0.5f, fl == 2 || fl == 3 ? 1.5f : 1.0f};
        }
        if (this.pos == 29 || this.pos == 38 || this.pos == 47) {
            return new float[]{fw == 2 ? 0.25f : 0.0f, 0.0f, fw == 5 ? 0.25f : 0.0f, fw == 3 ? 0.75f : 1.0f, 1.0f, fw == 4 ? 0.75f : 1.0f};
        }
        if (this.pos == 44) {
            return new float[]{fw == 3 ? 0.875f : 0.0f, 0.0f, fw == 4 ? 0.875f : 0.0f, fw == 2 ? 0.125f : 1.0f, 1.0f, fw == 5 ? 0.125f : 1.0f};
        }
        if (this.pos == 35) {
            float[] fArray = new float[6];
            fArray[0] = fl == 5 ? 0.375f : (fl == 4 ? 0.5f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == 3 ? 0.375f : (fArray[2] = fl == 2 ? 0.5f : 0.0f);
            fArray[3] = fl == 5 ? 0.5f : (fl == 4 ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == 3 ? 0.5f : (fl == 2 ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.pos == 53) {
            float[] fArray = new float[6];
            fArray[0] = fl == 4 ? 0.375f : (fl == 5 ? 0.5f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == 2 ? 0.375f : (fArray[2] = fl == 3 ? 0.5f : 0.0f);
            fArray[3] = fl == 4 ? 0.5f : (fl == 5 ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == 2 ? 0.5f : (fl == 3 ? 0.625f : 1.0f);
            return fArray;
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

