/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockFakeLight;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityFloodlight
extends TileEntityImmersiveConnectable {
    public int energyStorage = 0;
    public boolean active = false;
    public int facing = -1;
    public int side = 1;
    public float rotY = 0.0f;
    public float rotX = 0.0f;
    public List<ChunkCoordinates> fakeLights = new ArrayList<ChunkCoordinates>();
    public List<ChunkCoordinates> lightsToBePlaced = new ArrayList<ChunkCoordinates>();
    public List<ChunkCoordinates> lightsToBeRemoved = new ArrayList<ChunkCoordinates>();
    final int timeBetweenSwitches = 20;
    int switchCooldown = 0;
    public int computerTurnCooldown = 0;
    public boolean computerControlled;
    public boolean computerOn;
    private boolean shouldUpdate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity() {
        if (this.worldObj.isRemote) {
            return;
        }
        boolean b = this.active;
        if (this.shouldUpdate) {
            this.updateFakeLights(true, this.active);
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.shouldUpdate = false;
        }
        boolean enabled = this.computerControlled ? this.computerOn : !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
        if (this.energyStorage >= (!this.active ? 50 : 5) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= 5;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        --this.computerTurnCooldown;
        if (this.computerTurnCooldown == 0) {
            TileEntityFloodlight tileEntityFloodlight = this;
            synchronized (tileEntityFloodlight) {
                this.notifyAll();
            }
        }
        if (this.active != b || this.worldObj.getTotalWorldTime() % 512L == (long)((this.xCoord ^ this.zCoord) & 0x1FF)) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.updateFakeLights(true, this.active);
        }
        if (!this.active) {
            if (!this.lightsToBePlaced.isEmpty()) {
                this.lightsToBePlaced.clear();
            }
        } else if (!this.lightsToBePlaced.isEmpty() || !this.lightsToBeRemoved.isEmpty() && this.worldObj.getTotalWorldTime() % 8L == (long)((this.xCoord ^ this.zCoord) & 7)) {
            ChunkCoordinates cc;
            Iterator<ChunkCoordinates> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                this.worldObj.setBlock(cc.posX, cc.posY, cc.posZ, IEContent.blockFakeLight, 0, 2);
                TileEntity te = this.worldObj.getTileEntity(cc.posX, cc.posY, cc.posZ);
                if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                    ((BlockFakeLight.TileEntityFakeLight)te).floodlightCoords = new int[]{this.xCoord, this.yCoord, this.zCoord};
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                if (this.worldObj.getTileEntity(cc.posX, cc.posY, cc.posZ) instanceof BlockFakeLight.TileEntityFakeLight) {
                    this.worldObj.setBlockToAir(cc.posX, cc.posY, cc.posZ);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<ChunkCoordinates> it = this.fakeLights.iterator();
        ArrayList<ChunkCoordinates> tempRemove = new ArrayList<ChunkCoordinates>();
        while (it.hasNext()) {
            ChunkCoordinates cc = it.next();
            TileEntity te = this.worldObj.getTileEntity(cc.posX, cc.posY, cc.posZ);
            if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == 3 ? 180 : (this.facing == 4 ? 90 : (this.facing == 5 ? -90 : 0));
            double angleX = Math.toRadians(this.rotX);
            double angleY = Math.toRadians(angle + this.rotY);
            Vec3[] rays = new Vec3[]{Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0), Vec3.createVectorHelper((double)0.0, (double)0.0, (double)1.0)};
            Matrix4 mat = new Matrix4();
            if (this.side == 0) {
                mat.rotate(Math.PI, this.facing < 4 ? 0.0 : 1.0, 0.0, this.facing < 4 ? 1.0 : 0.0);
            } else if (this.side != 1) {
                mat.rotate(1.5707963267948966, this.side == 2 ? -1.0 : (this.side == 3 ? 1.0 : 0.0), 0.0, this.side == 5 ? -1.0 : (this.side == 4 ? 1.0 : 0.0));
            }
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3 vec, int offset, ArrayList<ChunkCoordinates> checklist) {
        Vec3 light = Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.75), (double)((double)this.zCoord + 0.5));
        int range = 32;
        HashSet<ChunkCoordinates> ignore = new HashSet<ChunkCoordinates>();
        ignore.add(new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord));
        ChunkCoordinates hit = Utils.rayTraceForFirst(Utils.addVectors(vec, light), light.addVector(vec.xCoord * (double)range, vec.yCoord * (double)range, vec.zCoord * (double)range), this.worldObj, ignore);
        double maxDistance = hit != null ? Vec3.createVectorHelper((double)((double)hit.posX + 0.5), (double)((double)hit.posY + 0.75), (double)((double)hit.posZ + 0.5)).squareDistanceTo(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            int xx = this.xCoord + (int)Math.round(vec.xCoord * (double)i);
            int yy = this.yCoord + (int)Math.round(vec.yCoord * (double)i);
            int zz = this.zCoord + (int)Math.round(vec.zCoord * (double)i);
            double dist = vec.xCoord * (double)i * vec.xCoord * (double)i + vec.yCoord * (double)i * vec.yCoord * (double)i + vec.zCoord * (double)i * vec.zCoord * (double)i;
            if (dist > maxDistance) break;
            if (yy > 255 || yy < 0 || xx == this.xCoord && yy == this.yCoord && zz == this.zCoord || !this.worldObj.isAirBlock(xx, yy, zz)) continue;
            ChunkCoordinates cc = new ChunkCoordinates(xx, yy, zz);
            if (!checklist.remove(cc)) {
                this.lightsToBePlaced.add(cc);
            }
            i += 2;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.getBoolean("active");
        this.energyStorage = nbt.getInteger("energy");
        this.facing = nbt.getInteger("facing");
        this.side = nbt.getInteger("side");
        this.rotY = nbt.getFloat("rotY");
        this.rotX = nbt.getFloat("rotX");
        int lightAmount = nbt.getInteger("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.getIntArray("fakeLight_" + i);
            this.fakeLights.add(new ChunkCoordinates(icc[0], icc[1], icc[2]));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("energyStorage", this.energyStorage);
        nbt.setInteger("facing", this.facing);
        nbt.setInteger("side", this.side);
        nbt.setFloat("rotY", this.rotY);
        nbt.setFloat("rotX", this.rotX);
        nbt.setInteger("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            ChunkCoordinates cc = this.fakeLights.get(i);
            nbt.setIntArray("fakeLight_" + i, new int[]{cc.posX, cc.posY, cc.posZ});
        }
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < 80) {
            int accepted = Math.min(80 - this.energyStorage, amount);
            if (!simulate) {
                this.energyStorage += accepted;
            }
            return accepted;
        }
        return 0;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 1) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return super.receiveClientEvent(id, arg);
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        double z;
        double y;
        double x;
        int xDif = ((TileEntity)link).xCoord - this.xCoord;
        int yDif = ((TileEntity)link).yCoord - this.yCoord;
        int zDif = ((TileEntity)link).zCoord - this.zCoord;
        switch (this.side) {
            case 0: 
            case 1: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == 0 ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case 2: 
            case 3: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == 2 ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == 4 ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return Vec3.createVectorHelper((double)x, (double)y, (double)z);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double z;
        double y;
        double x;
        int yDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posX - this.xCoord : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posX - this.xCoord : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posY - this.yCoord : (yDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posY - this.yCoord : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posZ - this.zCoord : (con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posZ - this.zCoord : 0));
        switch (this.side) {
            case 0: 
            case 1: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == 0 ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case 2: 
            case 3: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == 2 ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == 4 ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return Vec3.createVectorHelper((double)x, (double)y, (double)z);
    }

    public void turnY(boolean down, boolean computer) {
        this.rotY = (float)((double)this.rotY + (down ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        if (computer) {
            this.computerTurnCooldown = 20;
        }
        this.shouldUpdate = true;
    }

    public void turnX(boolean up, boolean computer) {
        float newX = (this.rotX + (up ? 11.25f : -11.25f)) % 360.0f;
        if ((double)newX >= -11.25 && (double)newX <= 191.25) {
            this.rotX = newX;
        }
        if (computer) {
            this.computerTurnCooldown = 20;
        }
        this.shouldUpdate = true;
    }

    public boolean canComputerTurn() {
        return this.computerTurnCooldown <= 0 || !this.active;
    }
}

