/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceHeater
extends TileEntityIEBase
implements IEnergyReceiver {
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(256, Math.max(Config.getInt("heater_consumption"), Config.getInt("heater_speedupConsumption"))));
    public int[] sockets = new int[6];
    public boolean active = false;

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            boolean a = this.active;
            if (this.active) {
                this.active = false;
            }
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
                int consumed = 0;
                if (tileEntity != null) {
                    if (tileEntity instanceof ExternalHeaterHandler.IExternalHeatable) {
                        consumed = ((ExternalHeaterHandler.IExternalHeatable)tileEntity).doHeatTick(this.energyStorage.getEnergyStored(), this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord));
                    } else {
                        ExternalHeaterHandler.HeatableAdapter adapter = ExternalHeaterHandler.getHeatableAdapter(tileEntity.getClass());
                        if (adapter != null) {
                            consumed = adapter.doHeatTick(tileEntity, this.energyStorage.getEnergyStored(), this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord));
                        }
                    }
                }
                if (consumed <= 0) continue;
                this.energyStorage.extractEnergy(consumed, false);
                if (this.active) continue;
                this.active = true;
            }
            if (this.active != a) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, (Block)IEContent.blockMetalDevice, 1, this.active ? 1 : 0);
            }
        }
    }

    public boolean canHeat(TileEntityFurnace furnace) {
        ItemStack input = furnace.getStackInSlot(0);
        if (input == null) {
            return false;
        }
        ItemStack output = FurnaceRecipes.smelting().getSmeltingResult(input);
        if (output == null) {
            return false;
        }
        ItemStack existingOutput = furnace.getStackInSlot(2);
        if (existingOutput == null) {
            return true;
        }
        if (!existingOutput.isItemEqual(output)) {
            return false;
        }
        int stackSize = existingOutput.stackSize + output.stackSize;
        return stackSize <= furnace.getInventoryStackLimit() && stackSize <= output.getMaxStackSize();
    }

    public boolean showActiveTexture() {
        return this.active || this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
    }

    public void toggleSide(int side) {
        this.sockets[side] = this.sockets[side] == 1 ? 0 : 1;
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 1) {
            this.active = arg == 1;
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.sockets = nbt.getIntArray("sockets");
        if (this.sockets.length < 6) {
            this.sockets = new int[0];
        }
        this.active = nbt.getBoolean("active");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.setIntArray("sockets", this.sockets);
        nbt.setBoolean("active", this.active);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.sockets[from.ordinal()] == 1;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.sockets[from.ordinal()] == 0) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

