/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLightningRod
extends TileEntityMultiblockPart
implements IEnergyProvider {
    public EnergyStorage energyStorage = new EnergyStorage(Config.getInt("lightning_output"));
    ArrayList<ChunkCoordinates> fenceNet = null;
    int height;

    public static boolean _Immovable() {
        return true;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.formed && this.pos == 4) {
            if (this.energyStorage.getEnergyStored() > 0) {
                for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                    TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX * 2, this.yCoord, this.zCoord + fd.offsetZ * 2);
                    if (!(tileEntity instanceof IEnergyReceiver)) continue;
                    IEnergyReceiver ier = (IEnergyReceiver)tileEntity;
                    int accepted = ier.receiveEnergy(fd.getOpposite(), this.energyStorage.getEnergyStored(), true);
                    int extracted = this.energyStorage.extractEnergy(accepted, false);
                    ier.receiveEnergy(fd.getOpposite(), extracted, false);
                }
            }
            if (this.worldObj.getTotalWorldTime() % 256L == (long)((this.xCoord ^ this.zCoord) & 0xFF)) {
                this.fenceNet = null;
            }
            if (this.fenceNet == null) {
                this.fenceNet = this.getFenceNet();
            }
            if (this.fenceNet != null && this.worldObj.getTotalWorldTime() % 128L == (long)((this.xCoord ^ this.zCoord) & 0x7F) && (this.worldObj.isThundering() || this.worldObj.isRaining() && this.worldObj.rand.nextInt(10) == 0)) {
                int i = this.height + this.fenceNet.size();
                if (this.worldObj.rand.nextInt(4096 * this.worldObj.getHeight()) < i * (this.yCoord + i)) {
                    this.energyStorage.setEnergyStored(Config.getInt("lightning_output"));
                    ChunkCoordinates cc = this.fenceNet.get(this.worldObj.rand.nextInt(this.fenceNet.size()));
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(this.worldObj, (double)cc.posX, (double)cc.posY, (double)cc.posZ);
                    this.worldObj.addWeatherEffect((Entity)entityLightningBolt);
                    this.worldObj.spawnEntityInWorld((Entity)entityLightningBolt);
                }
            }
        }
    }

    ArrayList<ChunkCoordinates> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        for (int i = this.yCoord + 1; i < this.worldObj.getHeight() - 1; ++i) {
            if (!broken && this.worldObj.getBlock(this.xCoord, i, this.zCoord).equals((Object)IEContent.blockMetalDecoration) && this.worldObj.getBlockMetadata(this.xCoord, i, this.zCoord) == 0) {
                ++this.height;
                continue;
            }
            if (!this.worldObj.isAirBlock(this.xCoord, i, this.zCoord)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        ArrayList<ChunkCoordinates> openList = new ArrayList<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> closedList = new ArrayList<ChunkCoordinates>();
        openList.add(new ChunkCoordinates(this.xCoord, this.yCoord + this.height, this.zCoord));
        while (!openList.isEmpty() && closedList.size() < 256) {
            ChunkCoordinates next = (ChunkCoordinates)openList.get(0);
            if (!closedList.contains(next) && this.worldObj.getBlock(next.posX, next.posY, next.posZ).equals((Object)IEContent.blockMetalDecoration) && this.worldObj.getBlockMetadata(next.posX, next.posY, next.posZ) == 0) {
                closedList.add(next);
                openList.add(new ChunkCoordinates(next.posX + 1, next.posY, next.posZ));
                openList.add(new ChunkCoordinates(next.posX - 1, next.posY, next.posZ));
                openList.add(new ChunkCoordinates(next.posX, next.posY, next.posZ + 1));
                openList.add(new ChunkCoordinates(next.posX, next.posY, next.posZ - 1));
                openList.add(new ChunkCoordinates(next.posX, next.posY + 1, next.posZ));
            }
            openList.remove(0);
        }
        return closedList;
    }

    @Override
    public TileEntityLightningRod master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityLightningRod ? (TileEntityLightningRod)te : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        ForgeDirection fd = this.pos == 1 ? ForgeDirection.SOUTH : (this.pos == 7 ? ForgeDirection.NORTH : (this.pos == 3 ? ForgeDirection.EAST : ForgeDirection.WEST));
        return from == fd.getOpposite();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        TileEntityLightningRod master = this.master();
        if (master != null) {
            return master.energyStorage.extractEnergy(maxExtract, simulate);
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityLightningRod master = this.master();
        if (master != null) {
            return master.getEnergyStored(from);
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityLightningRod master = this.master();
        if (master != null) {
            return master.getMaxEnergyStored(from);
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockMetalMultiblocks, 1, 0);
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            TileEntityLightningRod master = this.master();
            if (master == null) {
                master = this;
            }
            for (int l = -1; l <= 1; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    int xx = master.xCoord + w;
                    int yy = master.yCoord;
                    int zz = master.zCoord + l;
                    ItemStack s = null;
                    TileEntity te = this.worldObj.getTileEntity(xx, yy, zz);
                    if (te instanceof TileEntityLightningRod) {
                        s = ((TileEntityLightningRod)te).getOriginalBlock();
                        ((TileEntityLightningRod)te).formed = false;
                    }
                    if (xx == this.xCoord && yy == this.yCoord && zz == this.zCoord) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                    if (xx == this.xCoord && yy == this.yCoord && zz == this.zCoord) {
                        this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                        continue;
                    }
                    if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                        this.worldObj.setBlockToAir(xx, yy, zz);
                    }
                    this.worldObj.setBlock(xx, yy, zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    this.worldObj.addBlockEvent(xx, yy, zz, (Block)IEContent.blockMetalMultiblocks, 0, 0);
                }
            }
        }
    }
}

