/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockRefinery;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityRefinery
extends TileEntityMultiblockPart
implements IFluidHandler,
IEnergyReceiver,
ISidedInventory {
    public int facing = 2;
    public FluidTank tank0 = new FluidTank(12000);
    public FluidTank tank1 = new FluidTank(12000);
    public FluidTank tank2 = new FluidTank(12000);
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(256, Config.getInt("refinery_consumption")));
    public ItemStack[] inventory = new ItemStack[6];
    public boolean computerControlled;
    public boolean computerOn;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityRefinery master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityRefinery ? (TileEntityRefinery)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockRefinery.instance.getStructureManual()[this.pos % 15 / 5][this.pos % 5][this.pos / 15];
        return s != null ? s.copy() : null;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 7) {
            return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
        }
        if (this.pos == 37) {
            return new float[]{this.facing == 4 ? 0.5f : 0.0f, 0.0f, this.facing == 2 ? 0.5f : 0.0f, this.facing == 5 ? 0.5f : 1.0f, 1.0f, this.facing == 3 ? 0.5f : 1.0f};
        }
        if (this.pos == 20 || this.pos == 25) {
            return new float[]{this.facing == 3 ? 0.1875f : 0.0f, 0.0f, this.facing == 4 ? 0.1875f : 0.0f, this.facing == 2 ? 0.8125f : 1.0f, 1.0f, this.facing == 5 ? 0.8125f : 1.0f};
        }
        if (this.pos == 24 || this.pos == 29) {
            return new float[]{this.facing == 2 ? 0.1875f : 0.0f, 0.0f, this.facing == 5 ? 0.1875f : 0.0f, this.facing == 3 ? 0.8125f : 1.0f, 1.0f, this.facing == 4 ? 0.8125f : 1.0f};
        }
        if (this.pos >= 5 && this.pos < 15 && this.pos != 9 || this.pos >= 35 && this.pos < 45) {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            float minY = this.pos / 5 > 1 ? 0.0f : 0.375f;
            float maxY = 1.0f;
            float f = this.facing == 3 ? 0.4375f : (minX = this.facing == 4 ? 0.6875f : 0.0f);
            float f2 = this.facing == 2 ? 0.5625f : (maxX = this.facing == 5 ? 0.3125f : 1.0f);
            float f3 = this.facing == 4 ? 0.4375f : (minZ = this.facing == 2 ? 0.6875f : 0.0f);
            float f4 = this.facing == 5 ? 0.5625f : (maxZ = this.facing == 3 ? 0.3125f : 1.0f);
            if (this.pos % 5 == 4) {
                minX += this.facing == 3 ? -0.4375f : (this.facing == 2 ? 0.4375f : 0.0f);
                maxX += this.facing == 3 ? -0.4375f : (this.facing == 2 ? 0.4375f : 0.0f);
                minZ += this.facing == 4 ? -0.4375f : (this.facing == 5 ? 0.4375f : 0.0f);
                maxZ += this.facing == 4 ? -0.4375f : (this.facing == 5 ? 0.4375f : 0.0f);
            }
            if (this.pos / 15 == 2) {
                minX += this.facing == 4 ? -0.6875f : (this.facing == 5 ? 0.6875f : 0.0f);
                maxX += this.facing == 4 ? -0.6875f : (this.facing == 5 ? 0.6875f : 0.0f);
                minZ += this.facing == 3 ? 0.6875f : (this.facing == 2 ? -0.6875f : 0.0f);
                maxZ += this.facing == 3 ? 0.6875f : (this.facing == 2 ? -0.6875f : 0.0f);
            }
            if (this.pos % 5 != 0 && this.pos % 5 != 4) {
                minX = this.facing == 2 || this.facing == 3 ? 0.0f : minX;
                maxX = this.facing == 2 || this.facing == 3 ? 1.0f : maxX;
                minZ = this.facing == 4 || this.facing == 5 ? 0.0f : minZ;
                maxZ = this.facing == 4 || this.facing == 5 ? 1.0f : maxZ;
            }
            return new float[]{minX, minY, minZ, maxX, maxY, maxZ};
        }
        if (this.pos == 0 || this.pos == 1 || this.pos == 3 || this.pos == 30 || this.pos == 31 || this.pos == 33 || this.pos == 34) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 17) {
            return;
        }
        if (!this.worldObj.isRemote) {
            ItemStack emptyContainer;
            int consumed;
            DieselHandler.RefineryRecipe recipe;
            boolean enabled;
            boolean update = false;
            int prevAmount = this.tank2.getFluidAmount();
            if (this.computerControlled) {
                enabled = this.computerOn;
            } else {
                boolean bl = enabled = !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : (this.facing == 2 ? -2 : 2))), this.yCoord + 1, this.zCoord + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : (this.facing == 4 ? 2 : -2))));
            }
            if (enabled && (recipe = this.getRecipe(true)) != null && this.energyStorage.extractEnergy(consumed = Config.getInt("refinery_consumption"), true) == consumed && this.tank2.fill(recipe.output.copy(), false) == recipe.output.amount) {
                int drain1;
                int drain0 = this.tank0.getFluid().isFluidEqual(recipe.input0) ? recipe.input0.amount : recipe.input1.amount;
                int n = drain1 = this.tank0.getFluid().isFluidEqual(recipe.input0) ? recipe.input1.amount : recipe.input0.amount;
                if (this.tank0.getFluidAmount() >= drain0 && this.tank1.getFluidAmount() >= drain1) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.tank0.drain(drain0, true);
                    this.tank1.drain(drain1, true);
                    this.tank2.fill(recipe.output.copy(), true);
                    update = true;
                }
            }
            if (this.tank2.getFluidAmount() > 0 && (this.inventory[5] == null || this.inventory[5].stackSize < this.inventory[5].getMaxStackSize())) {
                ItemStack filledContainer = Utils.fillFluidContainer(this.tank2, this.inventory[4], this.inventory[5]);
                if (filledContainer != null) {
                    if (this.inventory[5] != null && OreDictionary.itemMatches((ItemStack)this.inventory[5], (ItemStack)filledContainer, (boolean)true)) {
                        this.inventory[5].stackSize += filledContainer.stackSize;
                    } else if (this.inventory[5] == null) {
                        this.inventory[5] = filledContainer.copy();
                    }
                    this.decrStackSize(4, filledContainer.stackSize);
                    update = true;
                }
                if (this.tank2.getFluidAmount() > 0) {
                    ForgeDirection f = ForgeDirection.getOrientation((int)this.facing);
                    int out = Math.min(144, this.tank2.getFluidAmount());
                    TileEntity te = Utils.getExistingTileEntity(this.worldObj, this.xCoord + f.offsetX * 2, this.yCoord, this.zCoord + f.offsetZ * 2);
                    if (te instanceof IFluidHandler && ((IFluidHandler)te).canFill(f.getOpposite(), this.tank2.getFluid().getFluid())) {
                        int accepted = ((IFluidHandler)te).fill(f.getOpposite(), new FluidStack(this.tank2.getFluid().getFluid(), out), false);
                        FluidStack drained = this.tank2.drain(accepted, true);
                        ((IFluidHandler)te).fill(f.getOpposite(), drained, true);
                    }
                }
            }
            if (this.tank2.getFluidAmount() != prevAmount) {
                update = true;
            }
            if ((emptyContainer = Utils.drainFluidContainer(this.tank0, this.inventory[0])) != null) {
                if (this.inventory[1] != null && OreDictionary.itemMatches((ItemStack)this.inventory[1], (ItemStack)emptyContainer, (boolean)true)) {
                    this.inventory[1].stackSize += emptyContainer.stackSize;
                } else if (this.inventory[1] == null) {
                    this.inventory[1] = emptyContainer.copy();
                }
                this.decrStackSize(0, emptyContainer.stackSize);
                update = true;
            }
            if ((emptyContainer = Utils.drainFluidContainer(this.tank1, this.inventory[2])) != null) {
                if (this.inventory[3] != null && OreDictionary.itemMatches((ItemStack)this.inventory[3], (ItemStack)emptyContainer, (boolean)true)) {
                    this.inventory[3].stackSize += emptyContainer.stackSize;
                } else if (this.inventory[3] == null) {
                    this.inventory[3] = emptyContainer.copy();
                }
                this.decrStackSize(2, emptyContainer.stackSize);
                update = true;
            }
            if (update) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public DieselHandler.RefineryRecipe getRecipe(boolean checkCapacity) {
        DieselHandler.RefineryRecipe recipe = DieselHandler.findRefineryRecipe(this.tank0.getFluid(), this.tank1.getFluid());
        if (recipe == null) {
            return null;
        }
        if (this.tank2.getFluid() == null || this.tank2.getFluid().isFluidEqual(recipe.output) && (!checkCapacity || this.tank2.getFluidAmount() + recipe.output.amount <= this.tank2.getCapacity())) {
            return recipe;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.tank0.readFromNBT(nbt.getCompoundTag("tank0"));
        this.tank1.readFromNBT(nbt.getCompoundTag("tank1"));
        this.tank2.readFromNBT(nbt.getCompoundTag("tank2"));
        this.energyStorage.readFromNBT(nbt);
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 6);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        NBTTagCompound tankTag = this.tank0.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank0", (NBTBase)tankTag);
        tankTag = this.tank1.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank1", (NBTBase)tankTag);
        tankTag = this.tank2.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank2", (NBTBase)tankTag);
        this.energyStorage.writeToNBT(nbt);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.formed) {
            return 0;
        }
        if (this.master() != null) {
            if (this.pos != 15 && this.pos != 19) {
                return 0;
            }
            return this.master().fill(from, resource, doFill);
        }
        if (resource != null) {
            int fill = 0;
            if (resource.isFluidEqual(this.tank0.getFluid())) {
                fill = this.tank0.fill(resource, doFill);
            } else if (resource.isFluidEqual(this.tank1.getFluid())) {
                fill = this.tank1.fill(resource, doFill);
            } else if (this.tank0.getFluidAmount() <= 0 && this.tank1.getFluidAmount() <= 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, null) != null ? this.tank0.fill(resource, doFill) : 0;
            } else if (this.tank0.getFluidAmount() > 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, this.tank0.getFluid()) != null ? this.tank1.fill(resource, doFill) : 0;
            } else if (this.tank1.getFluidAmount() > 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, this.tank1.getFluid()) != null ? this.tank0.fill(resource, doFill) : 0;
            }
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return fill;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 2) {
                return null;
            }
            return this.master().drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 2) {
                return null;
            }
            return this.master().drain(from, maxDrain, doDrain);
        }
        FluidStack drain = this.tank2.drain(maxDrain, doDrain);
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return drain;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.formed) {
            return false;
        }
        return this.pos == 15 || this.pos == 19;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.formed) {
            return false;
        }
        return this.pos == 2;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from.ordinal() <= 1) {
            return new FluidTankInfo[0];
        }
        switch (this.pos) {
            case 2: {
                return new FluidTankInfo[]{this.master() != null ? this.master().tank2.getInfo() : this.tank2.getInfo()};
            }
            case 15: 
            case 19: {
                TileEntityRefinery master = this.master();
                if (master != null) {
                    return new FluidTankInfo[]{master.tank0.getInfo(), master.tank1.getInfo()};
                }
                return new FluidTankInfo[]{this.tank0.getInfo(), this.tank1.getInfo()};
            }
        }
        return new FluidTankInfo[0];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 17 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing == 2 || this.facing == 3 ? 2 : 1)), (double)this.yCoord, (double)(this.zCoord - (this.facing == 4 || this.facing == 5 ? 2 : 1)), (double)(this.xCoord + (this.facing == 2 || this.facing == 3 ? 3 : 2)), (double)(this.yCoord + 3), (double)(this.zCoord + (this.facing == 4 || this.facing == 5 ? 3 : 2))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            int il = this.pos / 15;
            int ih = this.pos % 15 / 5 - 1;
            int iw = this.pos % 5 - 2;
            int startX = this.xCoord - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.yCoord - ih;
            int startZ = this.zCoord - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -2; w <= 2; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        if (w == 0 && (h == 1 || h == 0 && l == 1)) continue;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityRefinery) {
                            s = ((TileEntityRefinery)te).getOriginalBlock();
                            ((TileEntityRefinery)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 37 && ForgeDirection.getOrientation((int)this.facing).getOpposite().equals((Object)from);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.pos == 37 && this.master() != null && ForgeDirection.getOrientation((int)this.facing).getOpposite().equals((Object)from)) {
            TileEntityRefinery master = this.master();
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            if (rec > 0) {
                this.worldObj.markBlockForUpdate(this.master().xCoord, this.master().yCoord, this.master().zCoord);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        if (this.master() != null) {
            this.master().setInventorySlotContents(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return "IERefinery";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : this.formed && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().isItemValidForSlot(slot, stack);
        }
        if (slot == 1 || slot == 3 || slot == 5) {
            return false;
        }
        if (slot == 4) {
            return this.tank2.getFluidAmount() <= 0 ? FluidContainerRegistry.isEmptyContainer((ItemStack)stack) : FluidContainerRegistry.fillFluidContainer((FluidStack)this.tank2.getFluid(), (ItemStack)Utils.copyStackWithAmount(stack, 1)) != null;
        }
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fs == null) {
            return false;
        }
        DieselHandler.RefineryRecipe partialRecipe = DieselHandler.findIncompleteRefineryRecipe(fs, null);
        if (partialRecipe == null) {
            return false;
        }
        if (slot == 0) {
            return !(this.tank0.getFluidAmount() > 0 && !fs.isFluidEqual(this.tank0.getFluid()) || this.tank1.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, this.tank1.getFluid()) == null);
        }
        if (slot == 2) {
            return !(this.tank1.getFluidAmount() > 0 && !fs.isFluidEqual(this.tank1.getFluid()) || this.tank0.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, this.tank0.getFluid()) == null);
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.master() != null) {
            return this.master().getAccessibleSlotsFromSide(side);
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().canInsertItem(slot, stack, side);
        }
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().canExtractItem(slot, stack, side);
        }
        return slot == 1 || slot == 3 || slot == 5;
    }
}

