/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySampleDrill
extends TileEntityIEBase
implements IEnergyReceiver {
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public int pos = 0;
    public int process = 0;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public static boolean _Immovable() {
        return true;
    }

    public void updateEntity() {
        if (this.pos != 0 || this.worldObj.isRemote || this.worldObj.isAirBlock(this.xCoord, this.yCoord - 1, this.zCoord)) {
            return;
        }
        if (this.process < Config.getInt("coredrill_time") && this.energyStorage.extractEnergy(Config.getInt("coredrill_consumption"), false) == Config.getInt("coredrill_consumption")) {
            ++this.process;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)Config.getInt("coredrill_time");
    }

    public boolean isSamplingFinished() {
        return this.process >= Config.getInt("coredrill_time");
    }

    public String getVeinUnlocalizedName() {
        ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.worldObj, this.xCoord >> 4, this.zCoord >> 4);
        return mineral == null ? null : mineral.name;
    }

    public String getVeinLocalizedName() {
        String localizedName;
        String name = this.getVeinUnlocalizedName();
        if (name == null) {
            return null;
        }
        String unlocalizedName = "desc.ImmersiveEngineering.info.mineral." + name;
        if (unlocalizedName.equals(localizedName = StatCollector.translateToLocal((String)unlocalizedName))) {
            return name;
        }
        return localizedName;
    }

    public float getVeinIntegrity() {
        ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.worldObj, this.xCoord >> 4, this.zCoord >> 4);
        if (ExcavatorHandler.mineralVeinCapacity < 0 || info.depletion < 0) {
            return -1.0f;
        }
        if (info.mineralOverride == null && info.mineral == null) {
            return 0.0f;
        }
        return (float)(Config.getInt("excavator_depletion") - info.depletion) / (float)Config.getInt("excavator_depletion");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("pos", this.pos);
        nbt.setInteger("process", this.process);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.pos = nbt.getInteger("pos");
        this.process = nbt.getInteger("process");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 0 ? AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 3), (double)(this.zCoord + 1)) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.pos == 0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntity te;
        if (this.pos != 0 && (te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - this.pos, this.zCoord)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).receiveEnergy(from, maxReceive, simulate);
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntity te;
        if (this.pos != 0 && (te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - this.pos, this.zCoord)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getEnergyStored(from);
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntity te;
        if (this.pos != 0 && (te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - this.pos, this.zCoord)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getMaxEnergyStored(from);
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

