/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySheetmetalTank
extends TileEntityMultiblockPart
implements IFluidHandler,
IEBlockInterfaces.IBlockOverlayText {
    public FluidTank tank = new FluidTank(512000);
    private int[] oldComps = new int[4];
    private int masterCompOld;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntitySheetmetalTank master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntitySheetmetalTank ? (TileEntitySheetmetalTank)te : null;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getCurrentEquippedItem())) {
            FluidStack fs = this.master() != null ? this.master().tank.getFluid() : this.tank.getFluid();
            String s = null;
            s = fs != null ? fs.getLocalizedName() + ": " + fs.amount + "mB" : StatCollector.translateToLocal((String)"gui.ImmersiveEngineering.empty");
            return new String[]{s};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        if (this.pos == 4 && !this.worldObj.isRemote && this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
            for (int i = 0; i < 6; ++i) {
                if (i == 1 || this.tank.getFluidAmount() <= 0) continue;
                ForgeDirection f = ForgeDirection.getOrientation((int)i);
                int out = Math.min(144, this.tank.getFluidAmount());
                TileEntity te = this.worldObj.getTileEntity(this.xCoord + (i == 4 ? -1 : (i == 5 ? 1 : 0)), this.yCoord + (i == 0 ? -1 : 0), this.zCoord + (i == 2 ? -1 : (i == 3 ? 1 : 0)));
                if (te == null || !(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(f.getOpposite(), this.tank.getFluid().getFluid())) continue;
                this.updateComparatorValuesPart1();
                int accepted = ((IFluidHandler)te).fill(f.getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
                FluidStack drained = this.tank.drain(accepted, true);
                ((IFluidHandler)te).fill(f.getOpposite(), drained, true);
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.updateComparatorValuesPart2();
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8) {
            return new float[]{0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1) : new ItemStack((Block)IEContent.blockMetalDecoration, 1, 10);
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.worldObj.getTileEntity(startX, startY, startZ) instanceof TileEntitySheetmetalTank)) {
                return;
            }
            for (int yy = 0; yy <= 4; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntitySheetmetalTank) {
                            s = ((TileEntitySheetmetalTank)te).getOriginalBlock();
                            ((TileEntitySheetmetalTank)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource != null ? resource.getFluid() : null)) {
            return 0;
        }
        TileEntitySheetmetalTank master = this.master();
        if (master != null) {
            return master.fill(from, resource, doFill);
        }
        this.updateComparatorValuesPart1();
        int f = this.tank.fill(resource, doFill);
        if (f > 0 && doFill) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.updateComparatorValuesPart2();
        }
        return f;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from, resource != null ? resource.getFluid() : null)) {
            return null;
        }
        TileEntitySheetmetalTank master = this.master();
        if (master != null) {
            return master.drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        TileEntitySheetmetalTank master = this.master();
        if (master != null) {
            return master.drain(from, maxDrain, doDrain);
        }
        this.updateComparatorValuesPart1();
        FluidStack fs = this.tank.drain(maxDrain, doDrain);
        if (fs != null && fs.amount > 0 && doDrain) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.updateComparatorValuesPart2();
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && (this.pos == 4 || this.pos == 40);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.formed && this.pos == 4;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.pos == 4 || this.pos == 40) {
            if (!this.formed) {
                return new FluidTankInfo[0];
            }
            TileEntitySheetmetalTank master = this.master();
            if (master != null) {
                return master.getTankInfo(from);
            }
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)this.yCoord, (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 5), (double)(this.zCoord + 2)) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    public int getComparatorOutput() {
        if (this.pos == 4) {
            return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
        }
        TileEntitySheetmetalTank master = this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 4 && master != null) {
            FluidTank t = master.tank;
            int layer = this.offset[1] - 1;
            int vol = t.getCapacity() / 4;
            int filled = t.getFluidAmount() - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = this.tank.getCapacity() / 4;
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    private void updateComparatorValuesPart2() {
        int vol = this.tank.getCapacity() / 6;
        if (15 * this.tank.getFluidAmount() / this.tank.getCapacity() != this.masterCompOld) {
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        }
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            int y = this.yCoord - this.offset[1] + i + 1;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    this.worldObj.func_147453_f(this.xCoord - this.offset[0] + x, y, this.zCoord - this.offset[2] + z, this.worldObj.getBlock(this.xCoord - this.offset[0] + x, y, this.zCoord - this.offset[2] + z));
                }
            }
        }
    }
}

