/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntitySilo
extends TileEntityMultiblockPart
implements ISidedInventory,
IDeepStorageUnit {
    public ItemStack identStack;
    public int storageAmount = 0;
    static int maxStorage = 41472;
    ItemStack inputStack;
    ItemStack outputStack;
    ItemStack prevInputStack;
    ItemStack prevOutputStack;
    boolean lockItem = false;
    private int[] oldComps = new int[6];
    private int masterCompOld;
    private boolean forceUpdate = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntitySilo master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntitySilo ? (TileEntitySilo)te : null;
    }

    public void updateEntity() {
        if (this.pos == 4 && !this.worldObj.isRemote && this.outputStack == null && this.storageAmount > 0 && this.identStack != null) {
            this.markDirty();
        }
        if (this.pos == 4 && !this.worldObj.isRemote && this.outputStack != null && this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) && this.worldObj.getTotalWorldTime() % 8L == 0L) {
            this.updateComparatorValuesPart1();
            for (int i = 0; i < 6; ++i) {
                if (i == 1) continue;
                TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + (i == 4 ? -1 : (i == 5 ? 1 : 0)), this.yCoord + (i == 0 ? -1 : 0), this.zCoord + (i == 2 ? -1 : (i == 3 ? 1 : 0)));
                ItemStack stack = Utils.copyStackWithAmount(this.identStack, 1);
                if (inventory instanceof ISidedInventory && ((ISidedInventory)inventory).getAccessibleSlotsFromSide(ForgeDirection.OPPOSITES[i]).length > 0 || inventory instanceof IInventory && ((IInventory)inventory).getSizeInventory() > 0) {
                    stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[i]);
                }
                if (stack != null) continue;
                --this.outputStack.stackSize;
                this.markDirty();
                if (this.outputStack == null) break;
            }
            this.updateComparatorValuesPart2();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.hasKey("identStack")) {
            NBTTagCompound t = nbt.getCompoundTag("identStack");
            this.identStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)t);
        } else {
            this.identStack = null;
        }
        this.storageAmount = nbt.getInteger("storageAmount");
        this.lockItem = nbt.getBoolean("lockItem");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.identStack != null) {
            NBTTagCompound t = this.identStack.writeToNBT(new NBTTagCompound());
            nbt.setTag("identStack", (NBTBase)t);
        }
        nbt.setInteger("storageAmount", this.storageAmount);
        nbt.setBoolean("lockItem", this.lockItem);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8) {
            return new float[]{this.pos < 6 ? 0.0f : 0.75f, 0.0f, this.pos == 0 || this.pos == 6 ? 0.0f : 0.75f, this.pos > 2 ? 1.0f : 0.25f, 1.0f, this.pos == 2 || this.pos == 8 ? 1.0f : 0.25f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1) : new ItemStack((Block)IEContent.blockMetalDecoration, 1, 10);
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.worldObj.getTileEntity(startX, startY, startZ) instanceof TileEntitySilo)) {
                return;
            }
            for (int yy = 0; yy <= 6; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity tileEntity = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (tileEntity instanceof TileEntitySilo) {
                            s = ((TileEntitySilo)tileEntity).getOriginalBlock();
                            ((TileEntitySilo)tileEntity).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    public int getSizeInventory() {
        if (!this.formed || this.pos != 4 && this.pos != 58) {
            return 0;
        }
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntitySilo master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        return slot == 0 ? this.inputStack : this.outputStack;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        this.updateComparatorValuesPart1();
        if (!this.formed) {
            return null;
        }
        TileEntitySilo master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        if (this.outputStack == null) {
            return null;
        }
        int rem = Math.min(amount, this.outputStack.stackSize);
        ItemStack ret = Utils.copyStackWithAmount(this.outputStack, rem);
        this.outputStack.stackSize -= rem;
        if (this.outputStack.stackSize <= 0) {
            this.outputStack = null;
        }
        this.markDirty();
        this.updateComparatorValuesPart2();
        return ret;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.updateComparatorValuesPart1();
        if (!this.formed) {
            return;
        }
        TileEntitySilo master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        if (slot == 0) {
            this.inputStack = stack;
        } else {
            this.outputStack = stack;
        }
        this.markDirty();
        this.updateComparatorValuesPart2();
    }

    public String getInventoryName() {
        return "IESilo";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return maxStorage;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        TileEntitySilo master = this.master();
        if (master != null) {
            return master.isItemValidForSlot(slot, stack);
        }
        return this.identStack == null || OreDictionary.itemMatches((ItemStack)this.identStack, (ItemStack)stack, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)this.identStack);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (this.pos == 4 || this.pos == 58) {
            return new int[]{0, 1};
        }
        return new int[0];
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed || this.pos != 58 || slot != 0 || stack == null) {
            return false;
        }
        TileEntitySilo master = this.master();
        if (master != null) {
            return master.identStack == null || OreDictionary.itemMatches((ItemStack)master.identStack, (ItemStack)stack, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)master.identStack) && master.storageAmount < maxStorage;
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed || this.pos != 4 || slot != 1 || stack == null) {
            return false;
        }
        TileEntitySilo master = this.master();
        if (master != null) {
            return master.outputStack != null && OreDictionary.itemMatches((ItemStack)master.identStack, (ItemStack)stack, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)master.identStack);
        }
        return this.outputStack != null && OreDictionary.itemMatches((ItemStack)this.identStack, (ItemStack)stack, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)this.identStack);
    }

    public void markDirty() {
        super.markDirty();
        int oldStorage = this.storageAmount;
        if (this.inputStack != null) {
            if (this.identStack == null) {
                this.identStack = this.inputStack;
            }
            if (maxStorage - this.storageAmount > 0) {
                this.storageAmount = this.prevInputStack == null ? (this.storageAmount += this.inputStack.stackSize) : (this.storageAmount += this.inputStack.stackSize - this.prevInputStack.stackSize);
                if (this.storageAmount > maxStorage) {
                    this.storageAmount = maxStorage;
                }
            }
            if (maxStorage - this.storageAmount >= this.identStack.getMaxStackSize()) {
                this.inputStack = null;
                this.prevInputStack = null;
            } else {
                this.inputStack = Utils.copyStackWithAmount(this.identStack, this.identStack.getMaxStackSize() - (maxStorage - this.storageAmount));
                this.prevInputStack = this.inputStack.copy();
            }
        }
        if (this.prevOutputStack != null) {
            this.storageAmount = this.outputStack == null ? (this.storageAmount -= this.prevOutputStack.stackSize) : (this.storageAmount -= this.prevOutputStack.stackSize - this.outputStack.stackSize);
            if (this.storageAmount < 0) {
                this.storageAmount = 0;
            }
        }
        if (this.storageAmount == 0 && !this.lockItem) {
            this.identStack = null;
            this.outputStack = null;
            this.prevOutputStack = null;
            this.inputStack = null;
            this.prevInputStack = null;
            this.forceUpdate = true;
        } else if (this.identStack != null) {
            if (this.outputStack == null) {
                this.outputStack = this.identStack.copy();
            }
            this.outputStack.stackSize = Math.min(this.outputStack.getMaxStackSize(), this.storageAmount);
            this.prevOutputStack = this.outputStack.copy();
        }
        if (this.storageAmount != oldStorage || this.forceUpdate) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.forceUpdate = false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)this.yCoord, (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 7), (double)(this.zCoord + 2)) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public ItemStack getStoredItemType() {
        TileEntitySilo mast = this.master();
        if (mast != null) {
            return mast.getStoredItemType();
        }
        if (this.identStack != null) {
            return Utils.copyStackWithAmount(this.identStack, this.storageAmount);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        TileEntitySilo mast = this.master();
        if (mast != null) {
            mast.setStoredItemCount(amount);
            return;
        }
        this.updateComparatorValuesPart1();
        if (amount > maxStorage) {
            amount = maxStorage;
        }
        this.storageAmount = amount;
        this.forceUpdate = true;
        this.markDirty();
        this.updateComparatorValuesPart2();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        TileEntitySilo mast = this.master();
        if (mast != null) {
            mast.setStoredItemType(type, amount);
            return;
        }
        this.updateComparatorValuesPart1();
        this.identStack = Utils.copyStackWithAmount(type, 0);
        if (amount > maxStorage) {
            amount = maxStorage;
        }
        this.storageAmount = amount;
        this.forceUpdate = true;
        this.markDirty();
        this.updateComparatorValuesPart2();
    }

    @Override
    public int getMaxStoredCount() {
        return maxStorage;
    }

    public int getComparatorOutput() {
        if (this.pos == 4) {
            return 15 * this.storageAmount / maxStorage;
        }
        TileEntitySilo master = this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 6 && master != null) {
            int layer = this.offset[1] - 1;
            int vol = maxStorage / 6;
            int filled = master.storageAmount - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = maxStorage / 6;
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.storageAmount / maxStorage;
    }

    private void updateComparatorValuesPart2() {
        int vol = maxStorage / 6;
        if (15 * this.storageAmount / maxStorage != this.masterCompOld) {
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        }
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            int y = this.yCoord - this.offset[1] + i + 1;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    this.worldObj.func_147453_f(this.xCoord - this.offset[0] + x, y, this.zCoord - this.offset[2] + z, this.worldObj.getBlock(this.xCoord - this.offset[0] + x, y, this.zCoord - this.offset[2] + z));
                }
            }
        }
    }
}

