/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBlastFurnace
extends TileEntityMultiblockPart
implements ISidedInventory {
    ItemStack[] inventory = new ItemStack[4];
    public int facing = 2;
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    public int burnTime = 0;
    public int lastBurnTime = 0;

    @Override
    public TileEntityBlastFurnace master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityBlastFurnace ? (TileEntityBlastFurnace)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 2);
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.formed && this.master() == null) {
            boolean a = this.active;
            if (this.burnTime > 0) {
                if (this.process > 0) {
                    int processSpeed = this.getProcessSpeed();
                    if (this.inventory[0] == null) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        this.process -= processSpeed;
                        if (!this.active) {
                            this.active = true;
                        }
                    }
                    this.burnTime -= processSpeed;
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.process <= 0) {
                    BlastFurnaceRecipe recipe;
                    if (this.active) {
                        BlastFurnaceRecipe recipe2 = this.getRecipe();
                        if (recipe2 != null) {
                            this.decrStackSize(0, recipe2.input instanceof ItemStack ? ((ItemStack)recipe2.input).stackSize : 1);
                            if (this.inventory[2] != null) {
                                this.inventory[2].stackSize += recipe2.output.copy().stackSize;
                            } else {
                                this.inventory[2] = recipe2.output.copy();
                            }
                            if (recipe2.slag != null) {
                                if (this.inventory[3] != null) {
                                    this.inventory[3].stackSize += recipe2.slag.copy().stackSize;
                                } else {
                                    this.inventory[3] = recipe2.slag.copy();
                                }
                            }
                        }
                        this.processMax = 0;
                        this.active = false;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.processMax = this.process = recipe.time;
                        this.active = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && BlastFurnaceRecipe.isValidBlastFuel(this.inventory[1])) {
                this.burnTime += BlastFurnaceRecipe.getBlastFuelTime(this.inventory[1]);
                this.lastBurnTime = BlastFurnaceRecipe.getBlastFuelTime(this.inventory[1]);
                this.decrStackSize(1, 1);
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
            if (a != this.active) {
                int zMin;
                int xMax;
                int xMin;
                if (!this.active) {
                    this.turnOff();
                }
                this.markDirty();
                int n = this.facing == 5 ? -2 : (xMin = this.facing == 4 ? 0 : -1);
                int n2 = this.facing == 5 ? 0 : (xMax = this.facing == 4 ? 2 : 1);
                int n3 = this.facing == 3 ? -2 : (zMin = this.facing == 2 ? 0 : -1);
                int zMax = this.facing == 3 ? 0 : (this.facing == 2 ? 2 : 1);
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = xMin; xx <= xMax; ++xx) {
                        for (int zz = zMin; zz <= zMax; ++zz) {
                            TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz);
                            if (tileEntity != null) {
                                tileEntity.markDirty();
                            }
                            this.worldObj.markBlockForUpdate(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz);
                            this.worldObj.addBlockEvent(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz, (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public BlastFurnaceRecipe getRecipe() {
        BlastFurnaceRecipe recipe = BlastFurnaceRecipe.findRecipe(this.inventory[0]);
        if (recipe == null) {
            return null;
        }
        if (recipe.input instanceof ItemStack && ((ItemStack)recipe.input).stackSize > this.inventory[0].stackSize) {
            return null;
        }
        if (!(this.inventory[2] == null || OreDictionary.itemMatches((ItemStack)this.inventory[2], (ItemStack)recipe.output, (boolean)true) && this.inventory[2].stackSize + recipe.output.stackSize <= this.getInventoryStackLimit())) {
            return null;
        }
        if (!(this.inventory[3] == null || recipe.slag == null || OreDictionary.itemMatches((ItemStack)this.inventory[3], (ItemStack)recipe.slag, (boolean)true) && this.inventory[3].stackSize + recipe.slag.stackSize <= this.getInventoryStackLimit())) {
            return null;
        }
        return recipe;
    }

    protected int getProcessSpeed() {
        return 1;
    }

    protected void turnOff() {
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        BlastFurnaceRecipe recipe;
        if (!this.formed) {
            return;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        ItemStack old = this.inventory[slot];
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        if (!(slot != 0 || old != null && Utils.stackMatchesObject(stack, old) || (recipe = this.getRecipe()) == null)) {
            this.processMax = this.process = recipe.time;
        }
    }

    public String getInventoryName() {
        return "IEBlastFurnace";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.isItemValidForSlot(slot, stack);
        }
        if (BlastFurnaceRecipe.isValidBlastFuel(stack)) {
            return slot == 1;
        }
        if (slot == 0) {
            return BlastFurnaceRecipe.findRecipe(stack) != null;
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.canInsertItem(slot, stack, side);
        }
        return (slot == 0 || slot == 1) && this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.canExtractItem(slot, stack, side);
        }
        return slot == 2;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.process = nbt.getInteger("process");
        this.processMax = nbt.getInteger("processMax");
        this.active = nbt.getBoolean("active");
        this.burnTime = nbt.getInteger("burnTime");
        this.lastBurnTime = nbt.getInteger("lastBurnTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setInteger("process", this.process);
        nbt.setInteger("processMax", this.processMax);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("burnTime", this.burnTime);
        nbt.setInteger("lastBurnTime", this.lastBurnTime);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public void invalidate() {
        super.invalidate();
        this.disassemble();
    }

    protected void disassemble() {
        if (this.formed && !this.worldObj.isRemote) {
            int zMin;
            int xMax;
            int xMin;
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.worldObj.getTileEntity(startX, startY, startZ) instanceof TileEntityBlastFurnace)) {
                return;
            }
            int n = this.facing == 5 ? -2 : (xMin = this.facing == 4 ? 0 : -1);
            int n2 = this.facing == 5 ? 0 : (xMax = this.facing == 4 ? 2 : 1);
            int n3 = this.facing == 3 ? -2 : (zMin = this.facing == 2 ? 0 : -1);
            int zMax = this.facing == 3 ? 0 : (this.facing == 2 ? 2 : 1);
            for (int yy = -1; yy <= 1; ++yy) {
                for (int xx = xMin; xx <= xMax; ++xx) {
                    for (int zz = zMin; zz <= zMax; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityBlastFurnace) {
                            s = ((TileEntityBlastFurnace)te).getOriginalBlock();
                            ((TileEntityBlastFurnace)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockStoneDevice) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }
}

