/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCokeOven
extends TileEntityMultiblockPart
implements ISidedInventory,
IFluidHandler {
    public FluidTank tank = new FluidTank(12000);
    ItemStack[] inventory = new ItemStack[4];
    public int facing = 2;
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;

    @Override
    public TileEntityCokeOven master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityCokeOven ? (TileEntityCokeOven)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 1);
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.formed && this.master() == null) {
            ItemStack filledContainer;
            CokeOvenRecipe recipe;
            boolean a = this.active;
            boolean b = false;
            if (this.process > 0) {
                if (this.inventory[0] == null) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe();
                    if (recipe == null || recipe.time != this.processMax) {
                        this.process = 0;
                        this.processMax = 0;
                        this.active = false;
                    } else {
                        --this.process;
                    }
                }
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            } else {
                if (this.active) {
                    recipe = this.getRecipe();
                    if (recipe != null) {
                        this.decrStackSize(0, 1);
                        if (this.inventory[1] != null) {
                            this.inventory[1].stackSize += recipe.output.copy().stackSize;
                        } else if (this.inventory[1] == null) {
                            this.inventory[1] = recipe.output.copy();
                        }
                        this.tank.fill(new FluidStack(IEContent.fluidCreosote, recipe.creosoteOutput), true);
                    }
                    this.processMax = 0;
                    this.active = false;
                }
                if ((recipe = this.getRecipe()) != null) {
                    this.processMax = this.process = recipe.time;
                    this.active = true;
                }
            }
            if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (this.inventory[3] == null || this.inventory[3].stackSize + 1 <= this.inventory[3].getMaxStackSize()) && (filledContainer = Utils.fillFluidContainer(this.tank, this.inventory[2], this.inventory[3])) != null) {
                if (this.inventory[3] != null && OreDictionary.itemMatches((ItemStack)this.inventory[3], (ItemStack)filledContainer, (boolean)true)) {
                    this.inventory[3].stackSize += filledContainer.stackSize;
                } else if (this.inventory[3] == null) {
                    this.inventory[3] = filledContainer.copy();
                }
                this.decrStackSize(2, filledContainer.stackSize);
                b = true;
            }
            if (a != this.active || b) {
                int zMin;
                int xMax;
                int xMin;
                this.markDirty();
                int n = this.facing == 5 ? -2 : (xMin = this.facing == 4 ? 0 : -1);
                int n2 = this.facing == 5 ? 0 : (xMax = this.facing == 4 ? 2 : 1);
                int n3 = this.facing == 3 ? -2 : (zMin = this.facing == 2 ? 0 : -1);
                int zMax = this.facing == 3 ? 0 : (this.facing == 2 ? 2 : 1);
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = xMin; xx <= xMax; ++xx) {
                        for (int zz = zMin; zz <= zMax; ++zz) {
                            TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz);
                            if (tileEntity != null) {
                                tileEntity.markDirty();
                            }
                            this.worldObj.markBlockForUpdate(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz);
                            this.worldObj.addBlockEvent(this.xCoord + xx, this.yCoord + yy, this.zCoord + zz, (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public CokeOvenRecipe getRecipe() {
        CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe(this.inventory[0]);
        if (recipe == null) {
            return null;
        }
        if ((this.inventory[1] == null || OreDictionary.itemMatches((ItemStack)this.inventory[1], (ItemStack)recipe.output, (boolean)false) && this.inventory[1].stackSize + recipe.output.stackSize <= this.getInventoryStackLimit()) && this.tank.getFluidAmount() + recipe.creosoteOutput <= this.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return "IECokeOven";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.isItemValidForSlot(slot, stack);
        }
        if (slot == 0) {
            return stack != null && CokeOvenRecipe.findRecipe(stack) != null;
        }
        if (slot == 2) {
            return stack != null && FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.getAccessibleSlotsFromSide(side);
        }
        return new int[]{0, 1, 2, 3};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.canInsertItem(slot, stack, side);
        }
        return (slot == 0 || slot == 2) && this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.canExtractItem(slot, stack, side);
        }
        return slot == 1 || slot == 3;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.process = nbt.getInteger("process");
        this.processMax = nbt.getInteger("processMax");
        this.active = nbt.getBoolean("active");
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setInteger("process", this.process);
        nbt.setInteger("processMax", this.processMax);
        nbt.setBoolean("active", this.active);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int zMin;
            int xMax;
            int xMin;
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.worldObj.getTileEntity(startX, startY, startZ) instanceof TileEntityCokeOven)) {
                return;
            }
            int n = this.facing == 5 ? -2 : (xMin = this.facing == 4 ? 0 : -1);
            int n2 = this.facing == 5 ? 0 : (xMax = this.facing == 4 ? 2 : 1);
            int n3 = this.facing == 3 ? -2 : (zMin = this.facing == 2 ? 0 : -1);
            int zMax = this.facing == 3 ? 0 : (this.facing == 2 ? 2 : 1);
            for (int yy = -1; yy <= 1; ++yy) {
                for (int xx = xMin; xx <= xMax; ++xx) {
                    for (int zz = zMin; zz <= zMax; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityCokeOven) {
                            s = ((TileEntityCokeOven)te).getOriginalBlock();
                            ((TileEntityCokeOven)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.drain(from, maxDrain, doDrain);
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.formed;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.formed) {
            return new FluidTankInfo[0];
        }
        TileEntityCokeOven master = this.master();
        if (master != null) {
            return master.getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

