/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.client.render.BlockRenderWoodenDecoration;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBlockWoodenDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWallmount;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockWoodenDecoration
extends BlockIEBase
implements IAquaConnectable {
    public BlockWoodenDecoration() {
        super("woodenDecoration", Material.wood, 2, ItemBlockWoodenDecoration.class, "treatedWood", "fence", "slab0", "slab1", "doubleSlab", "scaffolding", "wallMount");
        this.setHardness(2.0f);
        this.setResistance(5.0f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return BlockRenderWoodenDecoration.renderID;
    }

    @Override
    public int damageDropped(int meta) {
        if (meta == 3 || meta == 4) {
            return 2;
        }
        return super.damageDropped(meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (metadata == 4) {
            ret.add(new ItemStack((Block)this, 1, 2));
        }
        return ret;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 1) {
            return side == ForgeDirection.UP;
        }
        if (meta == 2) {
            return side == ForgeDirection.DOWN;
        }
        if (meta == 3) {
            return side == ForgeDirection.UP;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityWallmount) {
            if (side == ForgeDirection.UP) {
                return ((TileEntityWallmount)te).inverted;
            }
            if (side == ForgeDirection.DOWN) {
                return !((TileEntityWallmount)te).inverted;
            }
            return true;
        }
        return true;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x + (side == 4 ? 1 : (side == 5 ? -1 : 0)), y + (side == 0 ? 1 : (side == 1 ? -1 : 0)), z + (side == 2 ? 1 : (side == 3 ? -1 : 0)));
        if (meta == 1 || meta == 2 || meta == 3) {
            return true;
        }
        if (meta == 5) {
            return world.getBlock(x, y, z) != this || world.getBlockMetadata(x, y, z) != 5;
        }
        return super.shouldSideBeRendered(world, x, y, z, side);
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            if (i == 0 || i == 3) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        for (int i = 0; i < this.subNames.length; ++i) {
            if (i == 5) {
                this.icons[i][0] = iconRegister.registerIcon("immersiveengineering:scaffolding_top");
                this.icons[i][1] = iconRegister.registerIcon("immersiveengineering:scaffolding_side");
                continue;
            }
            if (i == 6) {
                this.icons[i][0] = iconRegister.registerIcon("immersiveengineering:wood_wallmount");
                this.icons[i][1] = iconRegister.registerIcon("immersiveengineering:wood_wallmount");
                continue;
            }
            this.icons[i][0] = iconRegister.registerIcon("immersiveengineering:treatedWood");
            this.icons[i][1] = iconRegister.registerIcon("immersiveengineering:treatedWood");
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 1) {
            this.setBlockBounds(this.canConnectFenceTo(world, x - 1, y, z) ? 0.0f : 0.375f, 0.0f, this.canConnectFenceTo(world, x, y, z - 1) ? 0.0f : 0.375f, this.canConnectFenceTo(world, x + 1, y, z) ? 1.0f : 0.625f, 1.0f, this.canConnectFenceTo(world, x, y, z + 1) ? 1.0f : 0.625f);
        } else if (world.getBlockMetadata(x, y, z) == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (world.getBlockMetadata(x, y, z) == 3) {
            this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (world.getTileEntity(x, y, z) instanceof TileEntityWallmount) {
            TileEntityWallmount arm = (TileEntityWallmount)world.getTileEntity(x, y, z);
            int f = arm.facing;
            if (arm.sideAttached > 0) {
                this.setBlockBounds(f == 4 ? 0.0f : (f == 5 ? 0.375f : 0.3125f), arm.inverted ? 0.3125f : 0.0f, f == 2 ? 0.0f : (f == 3 ? 0.375f : 0.3125f), f == 5 ? 1.0f : (f == 4 ? 0.625f : 0.6875f), arm.inverted ? 1.0f : 0.6875f, f == 3 ? 1.0f : (f == 2 ? 0.625f : 0.6875f));
            } else {
                this.setBlockBounds(f == 5 ? 0.0f : 0.3125f, arm.inverted ? 0.375f : 0.0f, f == 3 ? 0.0f : 0.3125f, f == 4 ? 1.0f : 0.6875f, arm.inverted ? 1.0f : 0.625f, f == 2 ? 1.0f : 0.6875f);
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block == this && world.getBlockMetadata(x, y, z) == 1) {
            return true;
        }
        return block != Blocks.fence_gate ? (block.getMaterial().isOpaque() && block.renderAsNormalBlock() ? block.getMaterial() != Material.gourd : false) : true;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        super.addCollisionBoxesToList(world, x, y, z, aabb, list, ent);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 1) {
            this.setBlockBounds(this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z) ? 0.0f : 0.375f, 0.0f, this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1) ? 0.0f : 0.375f, this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z) ? 1.0f : 0.625f, 1.5f, this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1) ? 1.0f : 0.625f);
        } else if (world.getBlockMetadata(x, y, z) == 5) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        } else {
            this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        }
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity ent) {
        if (world.getBlockMetadata(x, y, z) == 5) {
            float f5 = 0.15f;
            if (ent.motionX < (double)(-f5)) {
                ent.motionX = -f5;
            }
            if (ent.motionX > (double)f5) {
                ent.motionX = f5;
            }
            if (ent.motionZ < (double)(-f5)) {
                ent.motionZ = -f5;
            }
            if (ent.motionZ > (double)f5) {
                ent.motionZ = f5;
            }
            ent.fallDistance = 0.0f;
            if (ent.motionY < -0.15) {
                ent.motionY = -0.15;
            }
            if (ent.motionY < 0.0 && ent instanceof EntityPlayer && ent.isSneaking()) {
                ent.motionY = 0.05;
                return;
            }
            if (ent.isCollidedHorizontally) {
                ent.motionY = 0.2;
            }
        }
    }

    public boolean hasTileEntity(int meta) {
        return meta == 6;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 6: {
                return new TileEntityWallmount();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(int metadata) {
        return false;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return meta == 1 || meta == 6;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x, y, z);
        return meta == 1 || meta == 6;
    }
}

