/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWallmount;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockWoodenDecoration
extends ItemBlockIEBase {
    public ItemBlockWoodenDecoration(Block b) {
        super(b);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advInfo) {
        if (stack.getItemDamage() == 0) {
            list.add("This item is deprecated. Hold it in your inventory to update it.");
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean hand) {
        int meta;
        if (ent instanceof EntityPlayer && (meta = stack.getItemDamage()) == 0) {
            ((EntityPlayer)ent).inventory.setInventorySlotContents(slot, new ItemStack((Block)IEContent.blockTreatedWood, stack.stackSize));
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack.getItemDamage() != 2) {
            return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        Block block = world.getBlock(x, y, z);
        int x0 = x;
        int y0 = y;
        int z0 = z;
        int x1 = x + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int y1 = y + (side == 0 ? -1 : (side == 1 ? 1 : 0));
        int z1 = z + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        if (block == Blocks.snow_layer && (world.getBlockMetadata(x, y, z) & 7) < 1) {
            side = 1;
        } else if (block != Blocks.vine && block != Blocks.tallgrass && block != Blocks.deadbush && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        int metaStack = this.getMetadata(stack.getItemDamage());
        int meta = this.field_150939_a.onBlockPlaced(world, x, y, z, side, hitX, hitY, hitZ, metaStack);
        boolean metaMod = false;
        if (this.field_150939_a.equals(world.getBlock(x1, y1, z1)) && (world.getBlockMetadata(x, y, z) == 2 || world.getBlockMetadata(x, y, z) == 3)) {
            metaMod = world.setBlockMetadataWithNotify(x, y, z, 4, 3);
        }
        if (this.field_150939_a.equals(world.getBlock(x0, y0, z0))) {
            if (side == 1 && world.getBlockMetadata(x0, y0, z0) == 2) {
                metaMod = world.setBlockMetadataWithNotify(x0, y0, z0, 4, 3);
            } else if (side == 0 && world.getBlockMetadata(x0, y0, z0) == 3) {
                metaMod = world.setBlockMetadataWithNotify(x0, y0, z0, 4, 3);
            }
        }
        if (metaMod) {
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.stepSound.func_150496_b(), (this.field_150939_a.stepSound.getVolume() + 1.0f) / 2.0f, this.field_150939_a.stepSound.getPitch() * 0.8f);
            --stack.stackSize;
            return true;
        }
        if (side == 0 || side != 1 && (double)hitY >= 0.5) {
            meta = 3;
        }
        if (stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (y == 255 && this.field_150939_a.getMaterial().isSolid()) {
            return false;
        }
        if (world.canPlaceEntityOnSide(this.field_150939_a, x, y, z, false, side, (Entity)player, stack)) {
            if (this.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, meta)) {
                world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.stepSound.func_150496_b(), (this.field_150939_a.stepSound.getVolume() + 1.0f) / 2.0f, this.field_150939_a.stepSound.getPitch() * 0.8f);
                --stack.stackSize;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        TileEntity tileEntity;
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, meta);
        if (ret && (tileEntity = world.getTileEntity(x, y, z)) instanceof TileEntityWallmount) {
            int f;
            int playerViewQuarter = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
            ((TileEntityWallmount)tileEntity).facing = f = playerViewQuarter == 0 ? 2 : (playerViewQuarter == 1 ? 5 : (playerViewQuarter == 2 ? 3 : 4));
            boolean bl = side == 1 ? false : (side == 0 ? true : (((TileEntityWallmount)tileEntity).inverted = (double)hitY > 0.5));
            if (side < 2) {
                ((TileEntityWallmount)tileEntity).sideAttached = side + 1;
            }
        }
        return ret;
    }
}

