/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityWoodenBarrel
extends TileEntityIEBase
implements IFluidHandler,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{1, 0};
    public FluidTank tank = new FluidTank(12000);
    public static final int IGNITION_TEMPERATURE = 573;

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    public void updateEntity() {
        if (this.worldObj.isRemote) {
            return;
        }
        boolean update = false;
        for (int i = 0; i < 2; ++i) {
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[i] != 1) continue;
            ForgeDirection f = ForgeDirection.getOrientation((int)i);
            int out = Math.min(40, this.tank.getFluidAmount());
            TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord + f.offsetY, this.zCoord);
            if (te == null || !(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(f.getOpposite(), this.tank.getFluid().getFluid())) continue;
            int accepted = ((IFluidHandler)te).fill(f.getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
            FluidStack drained = this.tank.drain(accepted, true);
            ((IFluidHandler)te).fill(f.getOpposite(), drained, true);
            update = true;
        }
        if (update) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getCurrentEquippedItem())) {
            String s = null;
            s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : StatCollector.translateToLocal((String)"gui.ImmersiveEngineering.empty");
            return new String[]{s};
        }
        if (hammer && Config.getBoolean("colourblindSupport") && mop.sideHit < 2) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit)];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, ForgeDirection.OPPOSITES[mop.sideHit])];
            return new String[]{StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.blockSide.facing") + ": " + StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + i)), StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.blockSide.opposite") + ": " + StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + j))};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 2) {
            this.sideConfig = new int[]{-1, 0};
        }
        this.readTank(nbt);
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        this.writeTank(nbt, false);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.setTag("tank", (NBTBase)tankTag);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isFluidValid(resource) && this.canFill(from, resource.getFluid())) {
            int i = this.tank.fill(resource, doFill);
            if (i > 0) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
            return i;
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getTemperature(fluid) < 573 && !fluid.getFluid().isGaseous(fluid);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource != null ? resource.amount : 0, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            FluidStack f = this.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
            return f;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from != ForgeDirection.UNKNOWN && from.ordinal() < 2 && this.sideConfig[from.ordinal()] != -1) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }
}

