/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    HashMap<ItemStack, Double> outputs;

    public ArcRecyclingRecipe(HashMap<ItemStack, Double> outputs, Object input, int time, int energyPerTick) {
        super(null, input, null, time, energyPerTick, new Object[0]);
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
    }

    @Override
    public ItemStack[] getOutputs(ItemStack input, ItemStack[] additives) {
        if (this.outputs == null) {
            return new ItemStack[0];
        }
        float mod = !input.getItem().isDamageable() ? 1.0f : (float)(input.getMaxDamage() - input.getItemDamage()) / (float)input.getMaxDamage();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            String[] type;
            int nuggetOut;
            double scaledOut = (double)mod * e.getValue();
            if (scaledOut >= 1.0) {
                outs.add(Utils.copyStackWithAmount(e.getKey(), (int)scaledOut));
            }
            if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) <= 0 || (type = ApiUtils.getMetalComponentTypeAndMetal(e.getKey(), "ingot")) == null) continue;
            ItemStack nuggets = IEApi.getPreferredOreStack("nugget" + type[1]);
            outs.add(Utils.copyStackWithAmount(nuggets, nuggetOut));
        }
        return outs.toArray(new ItemStack[outs.size()]);
    }

    @Override
    public boolean matches(ItemStack input, ItemStack[] additives) {
        if (input != null && this.input instanceof ItemStack) {
            boolean ignoreMeta = input.isItemStackDamageable();
            ItemStack inStack = (ItemStack)this.input;
            return input.getItem().equals(inStack.getItem()) && (ignoreMeta || inStack.getItemDamage() == input.getItemDamage());
        }
        return false;
    }
}

