/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeOreCrushing
implements IRecipe {
    String oreName;
    ItemStack dust;

    public RecipeOreCrushing(String oreName, ItemStack dust) {
        this.oreName = oreName;
        this.dust = dust;
    }

    public boolean matches(InventoryCrafting inv, World world) {
        ItemStack hammer = null;
        ItemStack ore = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot == null) continue;
            if (hammer == null && stackInSlot.getItem().getToolClasses(stackInSlot).contains("IE_HAMMER")) {
                hammer = stackInSlot;
                continue;
            }
            if (ore == null && Utils.compareToOreName(stackInSlot, "ore" + this.oreName)) {
                ore = stackInSlot;
                continue;
            }
            return false;
        }
        return hammer != null && ore != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.getRecipeOutput();
    }

    public int getRecipeSize() {
        return 10;
    }

    public ItemStack getRecipeOutput() {
        return this.dust != null ? this.dust.copy() : null;
    }
}

