/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityChemthrowerShot
extends EntityIEProjectile {
    private Fluid fluid;
    static final int dataMarker_fluid = 13;

    public EntityChemthrowerShot(World world) {
        super(world);
    }

    public EntityChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, Fluid fluid) {
        super(world, x, y, z, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, Fluid fluid) {
        super(world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(13, (Object)0);
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.dataWatcher.updateObject(13, (Object)FluidRegistry.getFluidID((Fluid)this.getFluid()));
        }
    }

    public Fluid getFluidSynced() {
        return FluidRegistry.getFluid((int)this.dataWatcher.getWatchableObjectInt(13));
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid() != null) {
            boolean isGas = this.getFluid().isGaseous() || ChemthrowerHandler.isGas(this.getFluid());
            return (isGas ? 0.025f : 0.05f) * (float)(this.getFluid().getDensity() < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid());
    }

    public void onEntityUpdate() {
        Block b;
        if (this.getFluid() == null && this.worldObj.isRemote) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = this.worldObj.getBlock((int)this.posX, (int)this.posY, (int)this.posZ)) != null && this.canIgnite() && (b.getMaterial() == Material.fire || b.getMaterial() == Material.lava)) {
            this.setFire(6);
        }
        super.onEntityUpdate();
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote && this.getFluid() != null) {
            int tempDiff;
            int damage;
            boolean fire;
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(this.getFluid());
            boolean bl = fire = this.getFluid().getTemperature() > 1000;
            if (effect != null) {
                ItemStack thrower = null;
                EntityPlayer shooter = (EntityPlayer)this.getShooter();
                if (shooter != null) {
                    thrower = shooter.getCurrentEquippedItem();
                }
                if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                    effect.applyToEntity((EntityLivingBase)mop.entityHit, shooter, thrower, this.fluid);
                } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                    effect.applyToBlock(this.worldObj, mop, shooter, thrower, this.fluid);
                }
            } else if (mop.entityHit != null && this.getFluid().getTemperature() > 500 && mop.entityHit.attackEntityFrom(DamageSource.lava, (float)(damage = Math.abs(tempDiff = this.getFluid().getTemperature() - 300) / 500))) {
                mop.entityHit.hurtResistantTime = (int)((double)mop.entityHit.hurtResistantTime * 0.75);
            }
            if (mop.entityHit != null) {
                int f;
                int n = this.isBurning() ? this.fire : (f = fire ? 3 : 0);
                if (f > 0) {
                    mop.entityHit.setFire(f);
                    if (mop.entityHit.attackEntityFrom(DamageSource.inFire, 2.0f)) {
                        mop.entityHit.hurtResistantTime = (int)((double)mop.entityHit.hurtResistantTime * 0.75);
                    }
                }
            }
        }
    }
}

