/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageSkyhookSync;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySkylineHook
extends Entity {
    public ImmersiveNetHandler.Connection connection;
    public ChunkCoordinates target;
    public Vec3[] subPoints;
    public int targetPoint = 0;

    public EntitySkylineHook(World world) {
        super(world);
        this.setSize(0.125f, 0.125f);
    }

    public EntitySkylineHook(World world, double x, double y, double z, ImmersiveNetHandler.Connection connection, ChunkCoordinates target, Vec3[] subPoints) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
        this.setPosition(x, y, z);
        this.connection = connection;
        this.target = target;
        this.subPoints = subPoints;
        float f1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
        this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
    }

    protected void entityInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_70112_1_) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public void onUpdate() {
        EntityPlayer player = null;
        if (this.riddenByEntity instanceof EntityPlayer) {
            player = (EntityPlayer)this.riddenByEntity;
        }
        if (this.ticksExisted == 1 && !this.worldObj.isRemote) {
            IELogger.debug("init tick at " + System.currentTimeMillis());
            if (player instanceof EntityPlayerMP) {
                ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSkyhookSync(this), (EntityPlayerMP)player);
            }
        }
        super.onUpdate();
        if (this.worldObj.getTotalWorldTime() % 3L == 0L) {
            boolean lower;
            boolean upper = !this.isAir(this.worldObj, (int)this.posX, (int)this.posY - 1, (int)this.posZ);
            boolean bl = lower = !this.isAir(this.worldObj, (int)this.posX, (int)this.posY - 2, (int)this.posZ);
            if (upper || lower) {
                this.setDead();
                if (player instanceof EntityPlayerMP && !this.worldObj.isRemote) {
                    if (upper) {
                        this.setPlayerPos((EntityPlayerMP)player, player.posX, Math.ceil(player.posY) + 2.5, player.posZ);
                    } else {
                        this.setPlayerPos((EntityPlayerMP)player, player.posX, Math.ceil(player.posY) + 1.5, player.posZ);
                    }
                }
                return;
            }
        }
        if (this.subPoints != null && this.targetPoint < this.subPoints.length - 1) {
            double dist = this.subPoints[this.targetPoint].distanceTo(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ));
            IELogger.debug("dist: " + dist);
            if (dist <= 0.0) {
                this.posX = this.subPoints[this.targetPoint].xCoord;
                this.posY = this.subPoints[this.targetPoint].yCoord;
                this.posZ = this.subPoints[this.targetPoint].zCoord;
                ++this.targetPoint;
                if (player instanceof EntityPlayerMP) {
                    ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSkyhookSync(this), (EntityPlayerMP)player);
                }
                IELogger.debug("next vertex: " + this.targetPoint);
                return;
            }
            float speed = 2.0f;
            if (player != null && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ItemSkyhook) {
                speed = ((ItemSkyhook)player.getCurrentEquippedItem().getItem()).getSkylineSpeed(player.getCurrentEquippedItem());
            }
            Vec3 moveVec = SkylineHelper.getSubMovementVector(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ), this.subPoints[this.targetPoint], speed);
            this.motionX = moveVec.xCoord;
            this.motionY = moveVec.yCoord;
            this.motionZ = moveVec.zCoord;
        }
        if (this.target != null && this.targetPoint == this.subPoints.length - 1) {
            TileEntity end = this.worldObj.getTileEntity(this.target.posX, this.target.posY, this.target.posZ);
            IImmersiveConnectable iicEnd = Utils.toIIC(end, this.worldObj);
            if (iicEnd == null) {
                this.setDead();
                return;
            }
            Vec3 vEnd = Vec3.createVectorHelper((double)this.target.posX, (double)this.target.posY, (double)this.target.posZ);
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(this.connection));
            double gDist = vEnd.distanceTo(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ));
            IELogger.debug("distance to goal: " + gDist);
            if (gDist <= 0.3) {
                this.reachedTarget(end);
                return;
            }
            if (gDist > 5.0) {
                this.setDead();
                return;
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
        this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
            }
        }
        if (player != null) {
            double dx = this.posX - this.prevPosX;
            double dy = this.posY - this.prevPosY;
            double dz = this.posZ - this.prevPosZ;
            int distTrvl = Math.round(MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz)) * 100.0f);
            if (distTrvl > 0) {
                player.addStat(IEAchievements.statDistanceSkyhook, distTrvl);
            }
            if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x().writeStat(IEAchievements.statDistanceSkyhook) > 100000) {
                player.triggerAchievement((StatBase)IEAchievements.skyhookPro);
            }
        }
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void reachedTarget(TileEntity end) {
        this.setDead();
        IELogger.debug("last tick at " + System.currentTimeMillis());
        if (!(this.riddenByEntity instanceof EntityPlayer)) {
            return;
        }
        ItemStack hook = ((EntityPlayer)this.riddenByEntity).getCurrentEquippedItem();
        if (hook == null || !(hook.getItem() instanceof ItemSkyhook)) {
            return;
        }
        ImmersiveNetHandler.Connection line = SkylineHelper.getTargetConnection(this.worldObj, this.target.posX, this.target.posY, this.target.posZ, (EntityLivingBase)this.riddenByEntity, this.connection);
        if (line != null) {
            ((EntityPlayer)this.riddenByEntity).setItemInUse(hook, hook.getItem().getMaxItemUseDuration(hook));
            SkylineHelper.spawnHook((EntityPlayer)this.riddenByEntity, end, line);
        } else {
            ((EntityPlayer)this.riddenByEntity).motionX = this.motionX;
            ((EntityPlayer)this.riddenByEntity).motionY = this.motionY;
            ((EntityPlayer)this.riddenByEntity).motionZ = this.motionZ;
            IELogger.debug("player motion: " + ((EntityPlayer)this.riddenByEntity).motionX + "," + ((EntityPlayer)this.riddenByEntity).motionY + "," + ((EntityPlayer)this.riddenByEntity).motionZ);
        }
    }

    public Vec3 getLookVec() {
        float f1 = MathHelper.cos((float)(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.sin((float)(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.cos((float)(-this.rotationPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.sin((float)(-this.rotationPitch * ((float)Math.PI / 180)));
        return Vec3.createVectorHelper((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean canRenderOnFire() {
        return false;
    }

    public boolean isPushedByWater() {
        return false;
    }

    public double getMountedYOffset() {
        return -2.0;
    }

    protected void writeEntityToNBT(NBTTagCompound nbt) {
    }

    protected void readEntityFromNBT(NBTTagCompound nbt) {
    }

    public float getCollisionBorderSize() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public float getBrightness(float p_70013_1_) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_70070_1_) {
        return 0xF000F0;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        this.setDead();
        return true;
    }

    public boolean isAir(World w, int x, int y, int z) {
        ChunkCoordinates pos = new ChunkCoordinates(x, y, z);
        if (this.connection != null && (pos.equals((Object)this.connection.start) || pos.equals((Object)this.connection.end))) {
            return true;
        }
        Block b = w.getBlock(x, y, z);
        return b == null || b.isAir((IBlockAccess)w, x, y, z);
    }

    public void setPlayerPos(EntityPlayerMP player, double x, double y, double z) {
        player.playerNetServerHandler.setPlayerLocation(x, y, z, player.rotationYaw, player.rotationPitch);
    }
}

