/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.gui.IESlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ContainerRefinery
extends Container {
    TileEntityRefinery tile;
    int slotCount;

    public ContainerRefinery(InventoryPlayer inventoryPlayer, TileEntityRefinery tile) {
        int i;
        this.tile = tile;
        final TileEntityRefinery tileF = tile;
        this.addSlotToContainer(new IESlot.FluidContainer(this, (IInventory)tile, 0, 37, 15, false){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                if (fs == null) {
                    return false;
                }
                if (DieselHandler.findIncompleteRefineryRecipe(fs, null) == null) {
                    return false;
                }
                return !(tileF.tank0.getFluidAmount() > 0 && !fs.isFluidEqual(tileF.tank0.getFluid()) || tileF.tank1.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, tileF.tank1.getFluid()) == null);
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, (IInventory)tile, 1, 37, 54));
        this.addSlotToContainer(new IESlot.FluidContainer(this, (IInventory)tile, 2, 85, 15, false){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                if (fs == null) {
                    return false;
                }
                if (DieselHandler.findIncompleteRefineryRecipe(fs, null) == null) {
                    return false;
                }
                return !(tileF.tank1.getFluidAmount() > 0 && !fs.isFluidEqual(tileF.tank1.getFluid()) || tileF.tank0.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, tileF.tank0.getFluid()) == null);
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, (IInventory)tile, 3, 85, 54));
        this.addSlotToContainer(new IESlot.FluidContainer(this, (IInventory)tile, 4, 133, 15, true){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                return super.isItemValid(itemStack) || itemStack != null && itemStack.getItem() instanceof IFluidContainerItem;
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, (IInventory)tile, 5, 133, 54));
        this.slotCount = 6;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
    }

    public boolean canInteractWith(EntityPlayer p_75145_1_) {
        return this.tile.isUseableByPlayer(p_75145_1_);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot < this.slotCount) {
                if (!this.mergeItemStack(stackInSlot, this.slotCount, this.slotCount + 36, true)) {
                    return null;
                }
            } else {
                boolean b = true;
                for (int i = 0; i < this.slotCount; ++i) {
                    Slot s = this.getSlot(i);
                    if (s == null || !s.isItemValid(stackInSlot) || !this.mergeItemStack(stackInSlot, i, i + 1, true)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    return null;
                }
            }
            if (stackInSlot.stackSize == 0) {
                slotObject.putStack(null);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.stackSize == stack.stackSize) {
                return null;
            }
            slotObject.onPickupFromSlot(player, stackInSlot);
        }
        return stack;
    }
}

