/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.InventoryStorageItem;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerRevolver
extends Container {
    private World worldObj;
    private int blockedSlot;
    public IInventory input;
    ItemStack revolver = null;
    EntityPlayer player = null;
    public final int revolverSlots;
    public static int[][][] slotPositions = new int[][][]{new int[][]{{48, 11}, {56, 30}}, new int[][]{{48, 11}, {68, 3}, {78, 22}, {88, 3}, {98, 22}, {108, 3}, {118, 22}, {56, 30}}, new int[][]{{48, 3}, {67, 3}, {86, 3}, {105, 3}, {124, 11}, {132, 30}, {124, 49}, {105, 57}, {86, 49}, {86, 30}, {67, 30}, {48, 30}}};

    public ContainerRevolver(InventoryPlayer iinventory, World world) {
        this.worldObj = world;
        this.player = iinventory.player;
        this.revolver = iinventory.getCurrentItem();
        this.revolverSlots = ((ItemRevolver)this.revolver.getItem()).getInternalSlots(this.revolver);
        this.input = new InventoryStorageItem(this, this.revolver);
        int bullets = ((ItemRevolver)this.revolver.getItem()).getBulletSlotAmount(this.revolver);
        int i = 0;
        int w = bullets >= 18 ? 150 : (bullets > 8 ? 136 : 74);
        int off = (176 - w) / 2;
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 29, 3, 1));
        int slots = bullets >= 18 ? 2 : (bullets > 8 ? 1 : 0);
        for (int[] slot : slotPositions[slots]) {
            this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + slot[0], slot[1], 1));
        }
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 48, 49, 1));
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 29, 57, 1));
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 10, 49, 1));
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 2, 30, 1));
        this.addSlotToContainer(new IESlot.Bullet(this, this.input, i++, off + 10, 11, 1));
        this.blockedSlot = iinventory.currentItem + 27 + i;
        this.bindPlayerInventory(iinventory);
        if (!world.isRemote) {
            try {
                ((InventoryStorageItem)this.input).stackList = ((ItemRevolver)this.revolver.getItem()).getContainedItems(this.revolver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onCraftMatrixChanged(this.input);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 143));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot < this.revolverSlots) {
                if (!this.mergeItemStack(stackInSlot, this.revolverSlots, this.inventorySlots.size(), true)) {
                    return null;
                }
            } else {
                return null;
            }
            if (stackInSlot.stackSize == 0) {
                slotObject.putStack(null);
            } else {
                slotObject.onSlotChanged();
            }
        }
        return stack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        if (par1 == this.blockedSlot || par3 == 2 && par2 == par4EntityPlayer.inventory.currentItem) {
            return null;
        }
        ((ItemRevolver)this.revolver.getItem()).setBullets(this.revolver, ((InventoryStorageItem)this.input).stackList);
        return super.slotClick(par1, par2, par3, par4EntityPlayer);
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        if (!this.worldObj.isRemote) {
            ((ItemRevolver)this.revolver.getItem()).setBullets(this.revolver, ((InventoryStorageItem)this.input).stackList);
            ItemStack hand = this.player.getCurrentEquippedItem();
            if (hand != null && !hand.equals(this.revolver)) {
                this.player.setCurrentItemOrArmor(0, this.revolver);
            }
            this.player.inventory.markDirty();
        }
    }
}

