/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.IWireCoil;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.InventoryStorageItem;
import blusunrize.immersiveengineering.common.items.ItemToolbox;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public class ContainerToolbox
extends Container
implements IESlot.ICallbackContainer {
    private World worldObj;
    private int blockedSlot;
    public IInventory input;
    ItemStack toolbox = null;
    EntityPlayer player = null;
    public final int internalSlots;

    public ContainerToolbox(InventoryPlayer iinventory, World world) {
        int j;
        this.worldObj = world;
        this.player = iinventory.player;
        this.toolbox = iinventory.getCurrentItem();
        this.internalSlots = ((ItemToolbox)this.toolbox.getItem()).getInternalSlots(this.toolbox);
        this.input = new InventoryStorageItem(this, this.toolbox);
        this.blockedSlot = iinventory.currentItem + 27 + this.internalSlots;
        int i = 0;
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 48, 24));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 30, 42));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 48, 42));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 75, 24));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 93, 24));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 111, 24));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 75, 42));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 93, 42));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 111, 42));
        this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 129, 42));
        for (j = 0; j < 6; ++j) {
            this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 35 + j * 18, 77));
        }
        for (j = 0; j < 7; ++j) {
            this.addSlotToContainer(new IESlot.ContainerCallback(this, this.input, i++, 26 + j * 18, 112));
        }
        this.bindPlayerInventory(iinventory);
        if (!world.isRemote) {
            try {
                ((InventoryStorageItem)this.input).stackList = ((ItemToolbox)this.toolbox.getItem()).getContainedItems(this.toolbox);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onCraftMatrixChanged(this.input);
    }

    @Override
    public boolean canInsert(ItemStack stack, int slotNumer, Slot slotObject) {
        if (stack == null) {
            return true;
        }
        if (((Object)((Object)IEContent.itemToolbox)).equals(stack.getItem())) {
            return false;
        }
        if (slotNumer < 3) {
            return stack.getItem() instanceof ItemFood;
        }
        if (slotNumer < 10) {
            if (stack.getItem() instanceof ITool) {
                return ((ITool)stack.getItem()).isTool(stack);
            }
            if (stack.getItem() instanceof ItemTool) {
                return true;
            }
        } else if (slotNumer < 16) {
            if (stack.getItem() instanceof IWireCoil) {
                return true;
            }
            if (Block.getBlockFromItem((Item)stack.getItem()) != null && Block.getBlockFromItem((Item)stack.getItem()).hasTileEntity(stack.getItemDamage())) {
                return Block.getBlockFromItem((Item)stack.getItem()).createTileEntity(this.worldObj, stack.getItemDamage()) instanceof IImmersiveConnectable;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean canTake(ItemStack stack, int slotNumer, Slot slotObject) {
        return true;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 157 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 215));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot < this.internalSlots) {
                if (!this.mergeItemStack(stackInSlot, this.internalSlots, this.internalSlots + 36, true)) {
                    return null;
                }
            } else if (stackInSlot != null) {
                boolean b = true;
                for (int i = 0; i < this.internalSlots; ++i) {
                    Slot s = (Slot)this.inventorySlots.get(i);
                    if (s == null || !s.isItemValid(stackInSlot) || !this.mergeItemStack(stackInSlot, i, i + 1, true)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    return null;
                }
            }
            if (stackInSlot.stackSize == 0) {
                slotObject.putStack(null);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.stackSize == stack.stackSize) {
                return null;
            }
            slotObject.onPickupFromSlot(this.player, stack);
        }
        return stack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        if (par1 == this.blockedSlot || par3 != 0 && par2 == par4EntityPlayer.inventory.currentItem) {
            return null;
        }
        ((ItemToolbox)this.toolbox.getItem()).setContainedItems(this.toolbox, ((InventoryStorageItem)this.input).stackList);
        return super.slotClick(par1, par2, par3, par4EntityPlayer);
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        if (!this.worldObj.isRemote) {
            ((ItemToolbox)this.toolbox.getItem()).setContainedItems(this.toolbox, ((InventoryStorageItem)this.input).stackList);
            ItemStack hand = this.player.getCurrentEquippedItem();
            if (hand != null && !this.toolbox.equals(hand)) {
                this.player.setCurrentItemOrArmor(0, this.toolbox);
            }
            this.player.inventory.markDirty();
        }
    }
}

