/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.tool.IInternalStorageItem;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryStorageItem
implements IInventory {
    private ItemStack itemStack;
    private Container container;
    public ItemStack[] stackList;
    private String name;

    public InventoryStorageItem(Container par1Container, ItemStack stack) {
        this.container = par1Container;
        if (stack != null && stack.getItem() instanceof IInternalStorageItem) {
            this.itemStack = stack;
            int slots = ((IInternalStorageItem)stack.getItem()).getInternalSlots(stack);
            this.stackList = new ItemStack[slots];
            this.name = stack.getDisplayName();
        }
    }

    public int getSizeInventory() {
        return this.stackList.length;
    }

    public ItemStack getStackInSlot(int i) {
        if (i >= this.getSizeInventory()) {
            return null;
        }
        return this.stackList[i];
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        if (this.stackList[i] != null) {
            ItemStack itemstack = this.stackList[i];
            this.stackList[i] = null;
            return itemstack;
        }
        return null;
    }

    public ItemStack decrStackSize(int i, int j) {
        if (this.stackList[i] != null) {
            if (this.stackList[i].stackSize <= j) {
                ItemStack itemstack = this.stackList[i];
                this.stackList[i] = null;
                this.markDirty();
                this.container.onCraftMatrixChanged((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = this.stackList[i].splitStack(j);
            if (this.stackList[i].stackSize == 0) {
                this.stackList[i] = null;
            }
            this.container.onCraftMatrixChanged((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack stack) {
        this.stackList[i] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.container.onCraftMatrixChanged((IInventory)this);
    }

    public String getInventoryName() {
        return "container." + this.name;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        if (this.itemStack != null) {
            ((IInternalStorageItem)this.itemStack.getItem()).setContainedItems(this.itemStack, this.stackList);
            if (this.itemStack.getItem() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)this.itemStack.getItem()).recalculateUpgrades(this.itemStack);
            }
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }
}

