/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ItemToolUpgrade
extends ItemIEBase
implements IUpgrade {
    public ItemToolUpgrade() {
        super("toolupgrade", 1, "drillWaterproof", "drillSpeed", "drillDamage", "drillCapacity", "revolverBayonet", "revolverMagazine", "revolverElectro", "chemthrowerFocus", "railgunScope", "railgunCapacitors");
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (stack.getItemDamage() < this.getSubNames().length) {
            String[] flavour;
            for (String s : flavour = ImmersiveEngineering.proxy.splitStringOnWidth(StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.flavour.toolupgrade." + this.getSubNames()[stack.getItemDamage()])), 200)) {
                list.add(s);
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        if (stack.getItemDamage() == 2) {
            return 3;
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        if (upgrade.getItemDamage() <= 2) {
            return ImmutableSet.of((Object)"DRILL");
        }
        if (upgrade.getItemDamage() == 3) {
            return ImmutableSet.of((Object)"DRILL", (Object)"CHEMTHROWER");
        }
        if (upgrade.getItemDamage() <= 6) {
            return ImmutableSet.of((Object)"REVOLVER");
        }
        if (upgrade.getItemDamage() == 7) {
            return ImmutableSet.of((Object)"CHEMTHROWER");
        }
        return ImmutableSet.of((Object)"RAILGUN");
    }

    @Override
    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        if (upgrade.getItemDamage() == 5 && target.getItem() instanceof IUpgradeableTool) {
            return !((IUpgradeableTool)target.getItem()).getUpgrades(target).hasKey("bullets");
        }
        return true;
    }

    @Override
    public void applyUpgrades(ItemStack target, ItemStack upgrade, HashMap<String, Object> modifications) {
        switch (upgrade.getItemDamage()) {
            case 0: {
                modifications.put("waterproof", true);
                break;
            }
            case 1: {
                Integer mod = (Integer)modifications.get("speed");
                modifications.put("speed", (mod == null ? 0 : mod) + 1);
                break;
            }
            case 2: {
                Integer mod = (Integer)modifications.get("damage");
                modifications.put("damage", (mod == null ? 0 : mod) + upgrade.stackSize);
                break;
            }
            case 3: {
                Integer mod = (Integer)modifications.get("capacity");
                modifications.put("capacity", (mod == null ? 0 : mod) + 2000);
                break;
            }
            case 4: {
                Float melee = (Float)modifications.get("melee");
                modifications.put("melee", Float.valueOf((melee == null ? 0.0f : melee.floatValue()) + 6.0f));
                break;
            }
            case 5: {
                Integer mod = (Integer)modifications.get("bullets");
                modifications.put("bullets", (mod == null ? 0 : mod) + 6);
                break;
            }
            case 6: {
                modifications.put("electro", true);
                break;
            }
            case 7: {
                modifications.put("focus", true);
                break;
            }
            case 8: {
                modifications.put("scope", true);
                break;
            }
            case 9: {
                modifications.put("speed", Float.valueOf(1.0f));
                modifications.put("capacity", 4000);
            }
        }
    }
}

