/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.IWireCoil;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemWireCoil
extends ItemIEBase
implements IWireCoil {
    public ItemWireCoil() {
        super("coil", 64, "copper", "electrum", "HV", "rope", "structural");
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        switch (stack.getItemDamage()) {
            default: {
                return WireType.COPPER;
            }
            case 1: {
                return WireType.ELECTRUM;
            }
            case 2: {
                return WireType.STEEL;
            }
            case 3: {
                return WireType.STRUCTURE_ROPE;
            }
            case 4: 
        }
        return WireType.STRUCTURE_STEEL;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (stack.getItemDamage() > 2) {
            list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.coil.construction0"));
            list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.coil.construction1"));
        }
        if (stack.getTagCompound() != null && stack.getTagCompound().hasKey("linkingPos") && (link = stack.getTagCompound().getIntArray("linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.isRemote && (tileEntity = world.getTileEntity(x, y, z)) instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(this.getWireType(stack), target)) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongCable", new Object[0]));
                return false;
            }
            if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.provider.dimensionId, x, y, z});
                target.writeToNBT(stack.getTagCompound());
            } else {
                WireType type = this.getWireType(stack);
                int[] pos = ItemNBTHelper.getIntArray(stack, "linkingPos");
                TileEntity tileEntityLinkingPos = world.getTileEntity(pos[1], pos[2], pos[3]);
                int distance = (int)Math.ceil(Math.sqrt((pos[1] - x) * (pos[1] - x) + (pos[2] - y) * (pos[2] - y) + (pos[3] - z) * (pos[3] - z)));
                if (pos[0] != world.provider.dimensionId) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongDimension", new Object[0]));
                } else if (pos[1] == x && pos[2] == y && pos[3] == z) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.sameConnection", new Object[0]));
                } else if (distance > type.getMaxLength()) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.tooFar", new Object[0]));
                } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(this.getWireType(stack), target)) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                } else {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                    boolean connectionExists = false;
                    Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
                    if (outputs != null) {
                        for (ImmersiveNetHandler.Connection con : outputs) {
                            if (!con.end.equals((Object)Utils.toCC(nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.connectionExists", new Object[0]));
                    } else {
                        Vec3 rtOff1;
                        Vec3 rtOff0 = nodeHere.getRaytraceOffset(nodeLink).addVector((double)x, (double)y, (double)z);
                        boolean canSee = Utils.canBlocksSeeOther(world, new ChunkCoordinates(x, y, z), new ChunkCoordinates(pos[1], pos[2], pos[3]), rtOff0, rtOff1 = nodeLink.getRaytraceOffset(nodeHere).addVector((double)pos[1], (double)pos[2], (double)pos[3]));
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT(stack.getTagCompound());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink), distance, type);
                            nodeHere.connectCable(type, target);
                            nodeLink.connectCable(type, targetLink);
                            IESaveData.setDirty(world.provider.dimensionId);
                            player.triggerAchievement((StatBase)IEAchievements.connectWire);
                            if (!player.capabilities.isCreativeMode) {
                                --stack.stackSize;
                            }
                            ((TileEntity)nodeHere).markDirty();
                            world.addBlockEvent(x, y, z, ((TileEntity)nodeHere).getBlockType(), -1, 0);
                            world.markBlockForUpdate(x, y, z);
                            ((TileEntity)nodeLink).markDirty();
                            world.addBlockEvent(pos[1], pos[2], pos[3], ((TileEntity)nodeLink).getBlockType(), -1, 0);
                            world.markBlockForUpdate(pos[1], pos[2], pos[3]);
                        } else {
                            player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove(stack, "linkingPos");
                ItemNBTHelper.remove(stack, "side");
                ItemNBTHelper.remove(stack, "hitX");
                ItemNBTHelper.remove(stack, "hitY");
                ItemNBTHelper.remove(stack, "hitZ");
            }
            return true;
        }
        return false;
    }
}

