/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class IESound
implements ITickableSound {
    public ISound.AttenuationType attenuation;
    public final ResourceLocation resource;
    public float volume;
    public float pitch;
    public float x;
    public float y;
    public float z;
    public boolean canRepeat;
    public int repeatDelay;
    public float volumeAjustment = 1.0f;
    public float[] origPos;
    public boolean donePlaying = false;

    public IESound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        this.attenuation = attenuation;
        this.resource = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.canRepeat = repeat;
        this.repeatDelay = repeatDelay;
        this.origPos = new float[]{(float)x, (float)y, (float)z};
    }

    public ISound.AttenuationType getAttenuationType() {
        return this.attenuation;
    }

    public ResourceLocation getPositionedSoundLocation() {
        return this.resource;
    }

    public float getVolume() {
        return this.volume * this.volumeAjustment;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getXPosF() {
        return this.x;
    }

    public float getYPosF() {
        return this.y;
    }

    public float getZPosF() {
        return this.z;
    }

    public boolean canRepeat() {
        return this.canRepeat;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void evaluateVolume() {
        this.volumeAjustment = 1.0f;
        for (int dx = (int)Math.floor(this.x - 8.0f) >> 4; dx <= (int)Math.floor(this.x + 8.0f) >> 4; ++dx) {
            for (int dz = (int)Math.floor(this.z - 8.0f) >> 4; dz <= (int)Math.floor(this.z + 8.0f) >> 4; ++dz) {
                for (TileEntity tile : ClientUtils.mc().thePlayer.worldObj.getChunkFromChunkCoords((int)dx, (int)dz).chunkTileEntityMap.values()) {
                    double d;
                    if (tile == null || !tile.getClass().getName().endsWith("TileEntitySoundMuffler") || tile.getBlockMetadata() == 1 || !((d = ((double)tile.xCoord + 0.5 - (double)this.x) * ((double)tile.xCoord + 0.5 - (double)this.x) + ((double)tile.yCoord + 0.5 - (double)this.y) * ((double)tile.yCoord + 0.5 - (double)this.y) + ((double)tile.zCoord + 0.5 - (double)this.z) * ((double)tile.zCoord + 0.5 - (double)this.z)) <= 64.0) || !(d > 0.0)) continue;
                    this.volumeAjustment = 0.1f;
                }
            }
        }
        TileEntity tile = ClientUtils.mc().thePlayer.worldObj.getTileEntity((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
        if (!(tile instanceof IEBlockInterfaces.ISoundTile)) {
            this.donePlaying = true;
        }
    }

    public void update() {
        if (ClientUtils.mc().thePlayer.worldObj.getTotalWorldTime() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean isDonePlaying() {
        return this.donePlaying;
    }
}

