/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SkylineHelper {
    public static ImmersiveNetHandler.Connection getTargetConnection(World world, int x, int y, int z, EntityLivingBase living, ImmersiveNetHandler.Connection invalidCon) {
        if (!(world.getTileEntity(x, y, z) instanceof IImmersiveConnectable)) {
            return null;
        }
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, new ChunkCoordinates(x, y, z));
        if (outputs != null && outputs.size() > 0) {
            Vec3 vec = living.getLookVec();
            vec = vec.normalize();
            ImmersiveNetHandler.Connection line = null;
            for (ImmersiveNetHandler.Connection c : outputs) {
                if (c == null || c.hasSameConnectors(invalidCon)) continue;
                if (line == null) {
                    line = c;
                    continue;
                }
                Vec3 lineVec = Vec3.createVectorHelper((double)(line.end.posX - line.start.posX), (double)(line.end.posY - line.start.posY), (double)(line.end.posZ - line.start.posZ)).normalize();
                Vec3 conVec = Vec3.createVectorHelper((double)(c.end.posX - c.start.posX), (double)(c.end.posY - c.start.posY), (double)(c.end.posZ - c.start.posZ)).normalize();
                if (!(conVec.distanceTo(vec) < lineVec.distanceTo(vec))) continue;
                line = c;
            }
            return line;
        }
        return null;
    }

    public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, ImmersiveNetHandler.Connection connection) {
        ChunkCoordinates cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
        ChunkCoordinates cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
        IImmersiveConnectable iicStart = Utils.toIIC(cc1, player.worldObj);
        IImmersiveConnectable iicEnd = Utils.toIIC(cc0, player.worldObj);
        Vec3 vStart = Vec3.createVectorHelper((double)cc1.posX, (double)cc1.posY, (double)cc1.posZ);
        Vec3 vEnd = Vec3.createVectorHelper((double)cc0.posX, (double)cc0.posY, (double)cc0.posZ);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
        }
        Vec3[] steps = SkylineHelper.getConnectionCatenary(connection, vStart, vEnd);
        double dx = steps[0].xCoord - vStart.xCoord;
        double dy = steps[0].yCoord - vStart.yCoord;
        double dz = steps[0].zCoord - vStart.zCoord;
        double d = 1.0;
        EntitySkylineHook hook = new EntitySkylineHook(player.worldObj, vStart.xCoord, vStart.yCoord, vStart.zCoord, connection, cc0, steps);
        float speed = 1.0f;
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ItemSkyhook) {
            speed = ((ItemSkyhook)player.getCurrentEquippedItem().getItem()).getSkylineSpeed(player.getCurrentEquippedItem());
        }
        Vec3 moveVec = SkylineHelper.getSubMovementVector(vStart, steps[0], speed);
        hook.motionX = moveVec.xCoord;
        hook.motionY = moveVec.yCoord;
        hook.motionZ = moveVec.zCoord;
        if (!player.worldObj.isRemote) {
            player.worldObj.spawnEntityInWorld((Entity)hook);
        }
        ItemSkyhook.existingHooks.put(player.getCommandSenderName(), hook);
        player.mountEntity((Entity)hook);
        return hook;
    }

    public static Vec3[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3 start, Vec3 end) {
        boolean vertical;
        boolean bl = vertical = connection.end.posX == connection.start.posX && connection.end.posZ == connection.start.posZ;
        if (vertical) {
            return new Vec3[]{Vec3.createVectorHelper((double)end.xCoord, (double)end.yCoord, (double)end.zCoord)};
        }
        double dx = end.xCoord - start.xCoord;
        double dy = end.yCoord - start.yCoord;
        double dz = end.zCoord - start.zCoord;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * connection.cableType.getSlack();
        double l = 0.0;
        for (int limiter = 0; !vertical && limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        int vertices = 16;
        Vec3[] vex = new Vec3[vertices];
        for (int i = 0; i < vertices; ++i) {
            float n1 = (float)(i + 1) / (float)vertices;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = Vec3.createVectorHelper((double)(start.xCoord + x1), (double)(start.yCoord + y1), (double)(start.zCoord + z1));
        }
        return vex;
    }

    public static Vec3 getSubMovementVector(Vec3 start, Vec3 target, float speed) {
        Vec3 movementVec = Vec3.createVectorHelper((double)(target.xCoord - start.xCoord), (double)(target.yCoord - start.yCoord), (double)(target.zCoord - start.zCoord));
        int lPixel = (int)Math.max(1.0, movementVec.lengthVector() / (0.125 * (double)speed));
        return Vec3.createVectorHelper((double)(movementVec.xCoord / (double)lPixel), (double)(movementVec.yCoord / (double)lPixel), (double)(movementVec.zCoord / (double)lPixel));
    }
}

