/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalChunkCoords;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static Method m_getHarvestLevel = null;

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = Utils.copyStackWithAmount(stack, 1);
        ArrayList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!ItemStack.areItemStacksEqual((ItemStack)comp, (ItemStack)st)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return Utils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).getItemDamage() == Short.MAX_VALUE || ItemStack.areItemStackTagsEqual((ItemStack)((ItemStack)o), (ItemStack)stack));
        }
        if (o instanceof ArrayList) {
            for (Object io : (ArrayList)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).getItemDamage() != Short.MAX_VALUE && !ItemStack.areItemStackTagsEqual((ItemStack)((ItemStack)io), (ItemStack)stack)) continue;
                return true;
            }
        } else if (o instanceof ItemStack[]) {
            for (ItemStack io : (ItemStack[])o) {
                if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.getItemDamage() != Short.MAX_VALUE && !ItemStack.areItemStackTagsEqual((ItemStack)io, (ItemStack)stack)) continue;
                return true;
            }
        } else if (o instanceof String) {
            return Utils.compareToOreName(stack, (String)o);
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        ItemStack s2 = stack.copy();
        s2.stackSize = amount;
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (stack.getItem().equals(Items.dye)) {
            return stack.getItemDamage();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.tag != null && fs.tag.hasKey("pressurized")) {
            fs.tag.removeTag("pressurized");
            if (fs.tag.hasNoTags()) {
                fs.tag = null;
            }
        }
        return fs;
    }

    public static ChunkCoordinates toCC(Object object) {
        if (object instanceof ChunkCoordinates) {
            return (ChunkCoordinates)object;
        }
        if (object instanceof TileEntity) {
            return new ChunkCoordinates(((TileEntity)object).xCoord, ((TileEntity)object).yCoord, ((TileEntity)object).zCoord);
        }
        return null;
    }

    public static DirectionalChunkCoords toDirCC(Object object, ForgeDirection direction) {
        if (object instanceof ChunkCoordinates) {
            return new DirectionalChunkCoords((ChunkCoordinates)object, direction);
        }
        if (object instanceof TileEntity) {
            return new DirectionalChunkCoords(((TileEntity)object).xCoord, ((TileEntity)object).yCoord, ((TileEntity)object).zCoord, direction);
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        TileEntity te;
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof ChunkCoordinates && world != null && world.blockExists(((ChunkCoordinates)object).posX, ((ChunkCoordinates)object).posY, ((ChunkCoordinates)object).posZ) && (te = world.getTileEntity(((ChunkCoordinates)object).posX, ((ChunkCoordinates)object).posY, ((ChunkCoordinates)object).posZ)) instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)te;
        }
        return null;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))));
    }

    public static String getModVersion(String modid) {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equalsIgnoreCase(modid)) continue;
            return container.getVersion();
        }
        return "";
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.xCoord == tile1.xCoord && tile0.yCoord == tile1.yCoord && tile0.zCoord == tile1.zCoord;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.prevRotationPitch + (living.rotationPitch - living.prevRotationPitch) * f;
        float f2 = living.prevRotationYaw + (living.rotationYaw - living.prevRotationYaw) * f;
        double d0 = living.prevPosX + (living.posX - living.prevPosX) * (double)f;
        double d1 = living.prevPosY + (living.posY - living.prevPosY) * (double)f + (double)(world.isRemote ? living.getEyeHeight() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.getEyeHeight());
        double d2 = living.prevPosZ + (living.posZ - living.prevPosZ) * (double)f;
        Vec3 vec3 = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).theItemInWorldManager.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.addVector((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, ChunkCoordinates cc0, ChunkCoordinates cc1, Vec3 pos0, Vec3 pos1) {
        HashSet<ChunkCoordinates> inter = Utils.rayTrace(pos0, pos1, world);
        for (ChunkCoordinates cc : inter) {
            if (cc.equals((Object)cc0) || cc.equals((Object)cc1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getItem().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static Vec3 getFlowVector(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) instanceof BlockFluidBase) {
            return ((BlockFluidBase)world.getBlock(x, y, z)).getFlowVector((IBlockAccess)world, x, y, z);
        }
        if (!(world.getBlock(x, y, z) instanceof BlockLiquid)) {
            return Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        }
        BlockLiquid block = (BlockLiquid)world.getBlock(x, y, z);
        Vec3 vec3 = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        Material mat = block.getMaterial();
        int l = Utils.getEffectiveFlowDecay((IBlockAccess)world, x, y, z, mat);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int l1;
            int j1 = x;
            int k1 = z;
            if (i1 == 0) {
                j1 = x - 1;
            }
            if (i1 == 1) {
                k1 = z - 1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++k1;
            }
            if ((l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y, k1, mat)) < 0) {
                if (world.getBlock(j1, y, k1).getMaterial().blocksMovement() || (l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y - 1, k1, mat)) < 0) continue;
                i2 = l1 - (l - 8);
                vec3 = vec3.addVector((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
                continue;
            }
            if (l1 < 0) continue;
            i2 = l1 - l;
            vec3 = vec3.addVector((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
        }
        if (world.getBlockMetadata(x, y, z) >= 8) {
            boolean flag = false;
            if (flag || block.isBlockSolid((IBlockAccess)world, x, y, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x, y, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x - 1, y, z, 4)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x + 1, y, z, 5)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x, y + 1, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x, y + 1, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x - 1, y + 1, z, 4)) {
                flag = true;
            }
            if (flag || block.isBlockSolid((IBlockAccess)world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec3 = vec3.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.normalize();
        return vec3;
    }

    static int getEffectiveFlowDecay(IBlockAccess world, int x, int y, int z, Material mat) {
        if (world.getBlock(x, y, z).getMaterial() != mat) {
            return -1;
        }
        int l = world.getBlockMetadata(x, y, z);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3 addVectors(Vec3 vec0, Vec3 vec1) {
        return vec0.addVector(vec1.xCoord, vec1.yCoord, vec1.zCoord);
    }

    public static Vec3 rotateVector(Vec3 vec0, double angleX, double angleY, double angleZ) {
        Vec3 vec1 = Vec3.createVectorHelper((double)vec0.xCoord, (double)vec0.yCoord, (double)vec0.zCoord);
        if (angleX != 0.0) {
            vec1.rotateAroundX((float)angleX);
        }
        if (angleY != 0.0) {
            vec1.rotateAroundY((float)angleY);
        }
        if (angleZ != 0.0) {
            vec1.rotateAroundZ((float)angleZ);
        }
        return vec1;
    }

    public static boolean isVecInEntityHead(EntityLivingBase entity, Vec3 vec) {
        if (entity.height / entity.width < 2.0f) {
            return false;
        }
        double d = vec.yCoord - (entity.posY + (double)entity.getEyeHeight());
        return Math.abs(d) < 0.25;
    }

    public static NBTTagCompound getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.setBoolean("Flicker", true);
        expl.setBoolean("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = ItemDye.field_150922_c[j];
        }
        expl.setIntArray("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.setByte("Type", (byte)type);
        NBTTagList list = new NBTTagList();
        list.appendTag((NBTBase)expl);
        tag.setTag("Explosions", (NBTBase)list);
        return tag;
    }

    public static FluidStack drainFluidBlock(World world, int x, int y, int z, boolean doDrain) {
        Block b = world.getBlock(x, y, z);
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (b instanceof IFluidBlock) {
                if (((IFluidBlock)b).canDrain(world, x, y, z)) {
                    return ((IFluidBlock)b).drain(world, x, y, z, doDrain);
                }
                return null;
            }
            if (world.getBlockMetadata(x, y, z) == 0) {
                if (doDrain) {
                    world.setBlockToAir(x, y, z);
                }
                return new FluidStack(f, 1000);
            }
            return null;
        }
        return null;
    }

    public static boolean placeFluidBlock(World world, int x, int y, int z, FluidStack fluid) {
        boolean canPlace;
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        Block b = world.getBlock(x, y, z);
        Block fluidBlock = fluid.getFluid().getBlock();
        if (Blocks.water.equals(fluidBlock)) {
            fluidBlock = Blocks.flowing_water;
        } else if (Blocks.lava.equals(fluidBlock)) {
            fluidBlock = Blocks.flowing_lava;
        }
        boolean bl = canPlace = b == null || b.isAir((IBlockAccess)world, x, y, z) || b.isReplaceable((IBlockAccess)world, x, y, z);
        if (fluidBlock != null && canPlace && fluid.amount >= 1000) {
            boolean placed = false;
            if (fluidBlock instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)fluidBlock;
                placed = world.setBlock(x, y, z, fluidBlock, blockFluid.getMaxRenderHeightMeta(), 3);
            } else {
                placed = world.setBlock(x, y, z, fluidBlock);
            }
            if (placed) {
                fluid.amount -= 1000;
            }
            return placed;
        }
        return false;
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.fluid.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer);
        }
        return containers;
    }

    public static String nameFromStack(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        try {
            return GameData.getItemRegistry().getNameForObject((Object)stack.getItem());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static ItemStack insertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return null;
        }
        int stackSize = stack.stackSize;
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.getAccessibleSlotsFromSide(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                ItemStack toInsert;
                ItemStack existingStack = inventory.getStackInSlot(slots[i]);
                if (existingStack == null || !sidedInv.canInsertItem(slots[i], toInsert = Utils.copyStackWithAmount(stack, Math.min(existingStack.getMaxStackSize(), inventory.getInventoryStackLimit()) - existingStack.stackSize), side) || !OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (inventory.getStackInSlot(slots[i]) != null || !sidedInv.canInsertItem(slots[i], Utils.copyStackWithAmount(stack, inventory.getInventoryStackLimit()), side)) continue;
                stack = Utils.addToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.getSizeInventory();
            for (i = 0; i < invSize && stack != null; ++i) {
                ItemStack existingStack = inventory.getStackInSlot(i);
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.getStackInSlot(i) != null) continue;
                stack = Utils.addToEmptyInventorySlot(inventory, i, stack);
            }
        }
        if (stack == null || stack.stackSize != stackSize) {
            inventory.markDirty();
        }
        return stack;
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.getInventoryStackLimit();
        inventory.setInventorySlotContents(slot, Utils.copyStackWithAmount(stack, Math.min(stack.stackSize, stackLimit)));
        return stackLimit >= stack.stackSize ? null : stack.splitStack(stack.stackSize - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.getInventoryStackLimit(), stack.getMaxStackSize());
        if (stack.stackSize + existingStack.stackSize > stackLimit) {
            int stackDiff = stackLimit - existingStack.stackSize;
            existingStack.stackSize = stackLimit;
            stack = Utils.copyStackWithAmount(stack, stack.stackSize - stackDiff);
            inventory.setInventorySlotContents(slot, existingStack);
            return stack;
        }
        existingStack.stackSize += Math.min(stack.stackSize, stackLimit);
        inventory.setInventorySlotContents(slot, existingStack);
        return null;
    }

    public static boolean canInsertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.getAccessibleSlotsFromSide(side);
            if (slots == null) {
                return false;
            }
            for (int i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.canInsertItem(slots[i], stack, side) || !sidedInv.isItemValidForSlot(slots[i], stack)) continue;
                ItemStack existingStack = inventory.getStackInSlot(slots[i]);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)existingStack) || existingStack.stackSize + stack.stackSize > inventory.getInventoryStackLimit() || existingStack.stackSize + stack.stackSize > existingStack.getMaxStackSize()) continue;
                return true;
            }
        } else {
            int invSize = inventory.getSizeInventory();
            for (int i = 0; i < invSize && stack != null; ++i) {
                if (!inventory.isItemValidForSlot(i, stack)) continue;
                ItemStack existingStack = inventory.getStackInSlot(i);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)existingStack) || existingStack.stackSize + stack.stackSize > inventory.getInventoryStackLimit() || existingStack.stackSize + stack.stackSize > existingStack.getMaxStackSize()) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack fillFluidContainer(FluidTank tank, ItemStack containerIn, ItemStack containerOut) {
        if (tank.getFluidAmount() > 0 && containerIn != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)containerIn)) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)containerIn);
                if (filledContainer != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
                    if (fs.amount <= tank.getFluidAmount() && (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)containerOut, (ItemStack)filledContainer))) {
                        tank.drain(fs.amount, true);
                        return filledContainer;
                    }
                }
            } else if (containerIn.getItem() instanceof IFluidContainerItem) {
                int space;
                IFluidContainerItem iContainer = (IFluidContainerItem)containerIn.getItem();
                int available = tank.getFluidAmount();
                if (available >= (space = iContainer.getCapacity(containerIn) - (iContainer.getFluid(containerIn) == null ? 0 : iContainer.getFluid((ItemStack)containerIn).amount)) && iContainer.fill(containerIn, tank.getFluid(), false) == space) {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)filledContainer, (ItemStack)containerOut)) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                } else if (containerIn.stackSize == 1) {
                    int filled = iContainer.fill(containerIn, tank.getFluid(), true);
                    tank.drain(filled, true);
                } else {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)filledContainer, (ItemStack)containerOut) && containerOut.stackSize + 1 < containerOut.getMaxStackSize()) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack drainFluidContainer(FluidTank tank, ItemStack containerIn) {
        ItemStack emptyContainer;
        FluidStack fs;
        if (containerIn != null && FluidContainerRegistry.isFilledContainer((ItemStack)containerIn) && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)containerIn)) != null && tank.getFluidAmount() + fs.amount <= tank.getCapacity() && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)containerIn)) != null && tank.fill(fs, true) == fs.amount) {
            return emptyContainer;
        }
        return null;
    }

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fluid != null) {
            return fluid;
        }
        if (stack.getItem() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.getItem()).getFluid(stack);
        }
        return null;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return FluidContainerRegistry.isContainer((ItemStack)stack) || stack.getItem() instanceof IFluidContainerItem;
    }

    public static boolean fillPlayerItemFromFluidHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        IFluidContainerItem container;
        if (tankFluid == null) {
            return false;
        }
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)equipped)) {
            ItemStack filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)equipped);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledStack);
            if (fluid == null || filledStack == null) {
                return false;
            }
            if (world.isRemote) {
                return true;
            }
            if (!player.capabilities.isCreativeMode) {
                if (equipped.stackSize == 1) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, filledStack);
                    --equipped.stackSize;
                    if (equipped.stackSize <= 0) {
                        equipped = null;
                    }
                } else {
                    --equipped.stackSize;
                    if (!player.inventory.addItemStackToInventory(filledStack)) {
                        player.func_146097_a(filledStack, false, true);
                    }
                    player.openContainer.detectAndSendChanges();
                    ((EntityPlayerMP)player).sendContainerAndContentsToPlayer(player.openContainer, player.openContainer.getInventory());
                }
            }
            handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            return true;
        }
        if (equipped.getItem() instanceof IFluidContainerItem && (container = (IFluidContainerItem)equipped.getItem()).fill(equipped, tankFluid, false) > 0) {
            int fill;
            if (world.isRemote) {
                return true;
            }
            if (equipped.stackSize > 1) {
                ItemStack filled = Utils.copyStackWithAmount(equipped, 1);
                --equipped.stackSize;
                fill = container.fill(filled, tankFluid, true);
                if (!player.inventory.addItemStackToInventory(filled)) {
                    player.func_146097_a(filled, false, true);
                }
            } else {
                fill = container.fill(equipped, tankFluid, true);
            }
            handler.drain(ForgeDirection.UNKNOWN, fill, true);
            player.openContainer.detectAndSendChanges();
            ((EntityPlayerMP)player).sendContainerAndContentsToPlayer(player.openContainer, player.openContainer.getInventory());
            return true;
        }
        return false;
    }

    public static boolean fillFluidHandlerWithPlayerItem(World world, IFluidHandler handler, EntityPlayer player) {
        IFluidContainerItem container;
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return false;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)equipped);
        if (fluid != null) {
            if (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.capabilities.isCreativeMode) {
                if (world.isRemote) {
                    return true;
                }
                ItemStack filledStack = FluidContainerRegistry.drainFluidContainer((ItemStack)equipped);
                if (!player.capabilities.isCreativeMode) {
                    if (equipped.stackSize == 1) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                        player.inventory.addItemStackToInventory(filledStack);
                    } else {
                        --equipped.stackSize;
                        if (filledStack != null && !player.inventory.addItemStackToInventory(filledStack)) {
                            player.func_146097_a(filledStack, false, true);
                        }
                    }
                    player.openContainer.detectAndSendChanges();
                    ((EntityPlayerMP)player).sendContainerAndContentsToPlayer(player.openContainer, player.openContainer.getInventory());
                }
                handler.fill(ForgeDirection.UNKNOWN, fluid, true);
                return true;
            }
        } else if (equipped.getItem() instanceof IFluidContainerItem && (fluid = (container = (IFluidContainerItem)equipped.getItem()).getFluid(equipped)) != null && handler.fill(ForgeDirection.UNKNOWN, fluid, false) > 0) {
            if (world.isRemote) {
                return true;
            }
            int fill = handler.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (equipped.stackSize > 1) {
                ItemStack emptied = Utils.copyStackWithAmount(equipped, 1);
                --equipped.stackSize;
                container.drain(emptied, fill, true);
                if (!player.inventory.addItemStackToInventory(emptied)) {
                    player.func_146097_a(emptied, false, true);
                }
            } else {
                container.drain(equipped, fill, true);
            }
            player.openContainer.detectAndSendChanges();
            ((EntityPlayerMP)player).sendContainerAndContentsToPlayer(player.openContainer, player.openContainer.getInventory());
            return true;
        }
        return false;
    }

    public static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        for (int i = 0; i < CraftingManager.getInstance().getRecipeList().size(); ++i) {
            IRecipe irecipe = (IRecipe)CraftingManager.getInstance().getRecipeList().get(i);
            if (!irecipe.matches(crafting, world)) continue;
            return irecipe;
        }
        return null;
    }

    public static HashSet<ChunkCoordinates> rayTrace(Vec3 start, Vec3 end, World world) {
        Vec3 tmp;
        HashSet<ChunkCoordinates> ret = new HashSet<ChunkCoordinates>();
        HashSet<ChunkCoordinates> checked = new HashSet<ChunkCoordinates>();
        if (start.xCoord > end.xCoord) {
            Vec3 tmp2 = start;
            start = end;
            end = tmp2;
        }
        double min = start.xCoord;
        double dif = end.xCoord - min;
        double lengthAdd = Math.ceil(min) - start.xCoord;
        Vec3 mov = start.subtract(end);
        if (mov.xCoord != 0.0) {
            mov = Utils.scalarProd(mov, 1.0 / mov.xCoord);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.diamond_ore);
        }
        if (mov.yCoord != 0.0) {
            if (start.yCoord > end.yCoord) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.yCoord;
            dif = end.yCoord - min;
            lengthAdd = Math.ceil(min) - start.yCoord;
            mov = start.subtract(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.yCoord);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.iron_ore);
        }
        if (mov.zCoord != 0.0) {
            if (start.zCoord > end.zCoord) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.zCoord;
            dif = end.zCoord - min;
            lengthAdd = Math.ceil(min) - start.zCoord;
            mov = start.subtract(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.zCoord);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.gold_ore);
        }
        return ret;
    }

    private static void ray(double dif, Vec3 mov, Vec3 start, double lengthAdd, HashSet<ChunkCoordinates> ret, World world, HashSet<ChunkCoordinates> checked, Block tmp) {
        boolean place = false;
        double standartOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            int meta;
            Block b;
            Vec3 pos = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd + standartOff));
            Vec3 posNext = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i + 1) + lengthAdd + standartOff));
            Vec3 posPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd - standartOff));
            Vec3 posVeryPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i - 1) + lengthAdd - standartOff));
            ChunkCoordinates cc = new ChunkCoordinates((int)Math.floor(pos.xCoord), (int)Math.floor(pos.yCoord), (int)Math.floor(pos.zCoord));
            if (!checked.contains(cc) && (double)i + lengthAdd + standartOff < dif) {
                b = world.getBlock(cc.posX, cc.posY, cc.posZ);
                if (b.canCollideCheck(meta = world.getBlockMetadata(cc.posX, cc.posY, cc.posZ), false) && b.collisionRayTrace(world, cc.posX, cc.posY, cc.posZ, pos, posNext) != null) {
                    ret.add(cc);
                }
                if (place) {
                    world.setBlock(cc.posX, cc.posY, cc.posZ, tmp);
                }
                checked.add(cc);
            }
            if (!checked.contains(cc = new ChunkCoordinates((int)Math.floor(posPrev.xCoord), (int)Math.floor(posPrev.yCoord), (int)Math.floor(posPrev.zCoord))) && (double)i + lengthAdd - standartOff < dif) {
                b = world.getBlock(cc.posX, cc.posY, cc.posZ);
                if (b.canCollideCheck(meta = world.getBlockMetadata(cc.posX, cc.posY, cc.posZ), false) && b.collisionRayTrace(world, cc.posX, cc.posY, cc.posZ, posVeryPrev, posPrev) != null) {
                    ret.add(cc);
                }
                if (place) {
                    world.setBlock(cc.posX, cc.posY, cc.posZ, tmp);
                }
                checked.add(cc);
            }
            ++i;
        }
    }

    public static Vec3 scalarProd(Vec3 v, double s) {
        return Vec3.createVectorHelper((double)(v.xCoord * s), (double)(v.yCoord * s), (double)(v.zCoord * s));
    }

    public static ChunkCoordinates rayTraceForFirst(Vec3 start, Vec3 end, World w, HashSet<ChunkCoordinates> ignore) {
        HashSet<ChunkCoordinates> trace = Utils.rayTrace(start, end, w);
        for (ChunkCoordinates cc : ignore) {
            trace.remove(cc);
        }
        if (start.xCoord != end.xCoord) {
            trace = Utils.findMinOrMax(trace, start.xCoord > end.xCoord, 0);
        }
        if (start.yCoord != end.yCoord) {
            trace = Utils.findMinOrMax(trace, start.yCoord > end.yCoord, 0);
        }
        if (start.zCoord != end.zCoord) {
            trace = Utils.findMinOrMax(trace, start.zCoord > end.zCoord, 0);
        }
        if (trace.size() > 0) {
            ChunkCoordinates ret = trace.iterator().next();
            return ret;
        }
        return null;
    }

    public static HashSet<ChunkCoordinates> findMinOrMax(HashSet<ChunkCoordinates> in, boolean max, int coord) {
        int curr;
        HashSet<ChunkCoordinates> ret = new HashSet<ChunkCoordinates>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ChunkCoordinates cc : in) {
            curr = coord == 0 ? cc.posX : (coord == 1 ? cc.posY : cc.posZ);
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (ChunkCoordinates cc : in) {
            curr = coord == 0 ? cc.posX : (coord == 1 ? cc.posY : cc.posZ);
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static TileEntity getExistingTileEntity(World world, int x, int y, int z) {
        if (world.blockExists(x, y, z)) {
            return world.getTileEntity(x, y, z);
        }
        return null;
    }

    public static ItemStack[] readInventory(NBTTagList nbt, int size) {
        ItemStack[] inv = new ItemStack[size];
        int max = nbt.tagCount();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound itemTag = nbt.getCompoundTagAt(i);
            int slot = itemTag.getByte("Slot") & 0xFF;
            if (slot < 0 || slot >= size) continue;
            inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag);
        }
        return inv;
    }

    public static NBTTagList writeInventory(ItemStack[] inv) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte("Slot", (byte)i);
            inv[i].writeToNBT(itemTag);
            invList.appendTag((NBTBase)itemTag);
        }
        return invList;
    }

    public static Map<String, Object> saveStack(ItemStack stack) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (stack != null && stack.getItem() != null) {
            ret.put("size", stack.stackSize);
            ret.put("name", Item.itemRegistry.getNameForObject((Object)stack.getItem()));
            ret.put("nameUnlocalized", stack.getUnlocalizedName());
            ret.put("label", stack.getDisplayName());
            ret.put("damage", stack.getItemDamage());
            ret.put("maxDamage", stack.getMaxDamage());
            ret.put("maxSize", stack.getMaxStackSize());
            ret.put("hasTag", stack.hasTagCompound());
        }
        return ret;
    }

    public static Map<String, Object> saveFluidTank(FluidTank tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getFluid().getUnlocalizedName());
            ret.put("amount", tank.getFluidAmount());
            ret.put("capacity", tank.getCapacity());
            ret.put("hasTag", tank.getFluid().tag != null);
        }
        return ret;
    }

    public static Map<String, Object> saveFluidStack(FluidStack tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getUnlocalizedName());
            ret.put("amount", tank.amount);
            ret.put("hasTag", tank.tag != null);
        }
        return ret;
    }

    public static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final Container nullContainer = new Container(){

            public void onCraftMatrixChanged(IInventory paramIInventory) {
            }

            public boolean canInteractWith(EntityPlayer p_75145_1_) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }
    }
}

