/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PeripheralAssembler
extends IEPeripheral {
    public static final String[] cmds = new String[]{"hasIngredients", "setEnabled", "getRecipe", "isValidRecipe", "getTank", "getMaxEnergyStored", "getEnergyStored", "getStackInSlot", "getBufferStack"};

    public PeripheralAssembler(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:assembler";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityAssembler te = (TileEntityAssembler)this.getTileEntity(TileEntityAssembler.class);
        if (te == null) {
            throw new LuaException("The assembler was removed");
        }
        switch (method) {
            case 0: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int recipe = (int)((Double)arguments[0]).doubleValue();
                if (recipe > 3 || recipe < 1) {
                    throw new LuaException("Only recipes 1-3 are available");
                }
                if (te.patterns[recipe - 1].inv[9] == null) {
                    throw new LuaException("The requested recipe is invalid");
                }
                ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
                for (ItemStack stack : te.inventory) {
                    if (stack == null) continue;
                    queryList.add(stack.copy());
                }
                return new Object[]{te.hasIngredients(te.patterns[recipe - 1], queryList)};
            }
            case 1: {
                if (arguments.length != 2 || !(arguments[1] instanceof Boolean) || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer and one boolean");
                }
                int recipe = (int)((Double)arguments[0]).doubleValue();
                boolean active = (Boolean)arguments[1];
                if (recipe > 3 || recipe < 1) {
                    throw new LuaException("Only recipes 1-3 are available");
                }
                te.computerOn[recipe - 1] = active;
                return null;
            }
            case 2: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int recipe = (int)((Double)arguments[0]).doubleValue();
                if (recipe > 3 || recipe < 1) {
                    throw new LuaException("Only recipes 1-3 are available");
                }
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
                for (int i = 0; i < 9; ++i) {
                    ret.put("in" + (i + 1), Utils.saveStack(te.patterns[recipe - 1].inv[i]));
                }
                ret.put("out", Utils.saveStack(te.patterns[recipe - 1].inv[9]));
                return new Object[]{ret};
            }
            case 3: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int recipe = (int)((Double)arguments[0]).doubleValue();
                if (recipe > 3 || recipe < 1) {
                    throw new LuaException("Only recipes 1-3 are available");
                }
                return new Object[]{te.patterns[recipe - 1].inv[9] != null};
            }
            case 4: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int tank = (int)((Double)arguments[0]).doubleValue();
                if (tank > 3 || tank < 1) {
                    throw new LuaException("Only tanks 1-3 are available");
                }
                return new Object[]{Utils.saveFluidTank(te.tanks[tank - 1])};
            }
            case 5: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 6: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
            case 7: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot > 18 || slot < 1) {
                    throw new LuaException("Only slots 1-18 are available");
                }
                return new Object[]{Utils.saveStack(te.getStackInSlot(slot - 1))};
            }
            case 8: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int recipe = (int)((Double)arguments[0]).doubleValue();
                if (recipe > 3 || recipe < 1) {
                    throw new LuaException("Only recipes 1-3 are available");
                }
                return new Object[]{Utils.saveStack(te.inventory[17 + recipe])};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityAssembler te = (TileEntityAssembler)this.getTileEntity(TileEntityAssembler.class);
        if (te == null) {
            return;
        }
        te.computerControlled = true;
        te.computerOn[0] = true;
        te.computerOn[1] = true;
        te.computerOn[2] = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityAssembler te = (TileEntityAssembler)this.getTileEntity(TileEntityAssembler.class);
        if (te == null) {
            return;
        }
        te.computerControlled = false;
    }
}

