/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.util.compat.minetweaker.MTHelper;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Crusher")
public class Crusher {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int energy, @Optional IItemStack secondaryOutput, @Optional double secondaryChance) {
        Object oInput = MTHelper.toObject(input);
        if (oInput == null) {
            MineTweakerAPI.getLogger().logError("Did not add crusher recipe for " + output.getDisplayName() + ", input was null");
            return;
        }
        CrusherRecipe r = new CrusherRecipe(MTHelper.toStack(output), oInput, energy);
        if (r.input == null) {
            MineTweakerAPI.getLogger().logError("Did not add crusher recipe for " + output.getDisplayName() + ", converted input was null");
            return;
        }
        if (secondaryOutput != null) {
            r.addToSecondaryOutput(MTHelper.toStack(secondaryOutput), Float.valueOf((float)secondaryChance));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<CrusherRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = CrusherRecipe.removeRecipes(this.output);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (CrusherRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    CrusherRecipe.recipeList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Crusher Recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Re-Adding Crusher Recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final CrusherRecipe recipe;

        public Add(CrusherRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CrusherRecipe.recipeList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CrusherRecipe.recipeList.remove(this.recipe);
        }

        public String describe() {
            return "Adding Crusher Recipe for " + this.recipe.output.getDisplayName();
        }

        public String describeUndo() {
            return "Removing Crusher Recipe for " + this.recipe.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

