/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.compat.minetweaker.MTHelper;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.MetalPress")
public class MetalPress {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, IItemStack mold, int energy, @Optional int inputSize) {
        Object oInput = MTHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        ItemStack sOut = MTHelper.toStack(output);
        ItemStack sMold = MTHelper.toStack(mold);
        if (sOut != null && sMold != null) {
            MetalPressRecipe r = new MetalPressRecipe(sOut, oInput, sMold, energy);
            if (inputSize > 0) {
                r.setInputSize(inputSize);
            }
            MineTweakerAPI.apply((IUndoableAction)new Add(r));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipeByMold(IItemStack mold) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveByMold(MTHelper.toStack(mold)));
    }

    private static class RemoveByMold
    implements IUndoableAction {
        private final ComparableItemStack mold;
        List<MetalPressRecipe> removedRecipes;

        public RemoveByMold(ItemStack mold) {
            this.mold = ApiUtils.createComparableItemStack(mold);
        }

        public void apply() {
            this.removedRecipes = MetalPressRecipe.recipeList.get((Object)this.mold);
            MetalPressRecipe.recipeList.removeAll((Object)this.mold);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                MetalPressRecipe.recipeList.putAll((Object)this.mold, this.removedRecipes);
            }
        }

        public String describe() {
            return "Removing Metal Press Recipes for Mold: " + this.mold.stack.getDisplayName();
        }

        public String describeUndo() {
            return "Re-Adding Metal Press Recipes for Mold: " + this.mold.stack.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<MetalPressRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = MetalPressRecipe.removeRecipes(this.output);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (MetalPressRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    MetalPressRecipe.recipeList.put((Object)recipe.mold, (Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Metal Press Recipes for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Re-Adding Metal Press Recipes for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final MetalPressRecipe recipe;

        public Add(MetalPressRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MetalPressRecipe.recipeList.put((Object)this.recipe.mold, (Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MetalPressRecipe.recipeList.remove((Object)this.recipe.mold, (Object)this.recipe);
        }

        public String describe() {
            return "Adding Metal Press Recipe for " + this.recipe.output.getDisplayName();
        }

        public String describeUndo() {
            return "Removing Metal Press Recipe for " + this.recipe.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

