/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MessageTileSync
implements IMessage {
    int dimension;
    int x;
    int y;
    int z;
    NBTTagCompound nbt;

    public MessageTileSync(TileEntityIEBase tile, NBTTagCompound nbt) {
        this.dimension = tile.getWorldObj().provider.dimensionId;
        this.x = tile.xCoord;
        this.y = tile.yCoord;
        this.z = tile.zCoord;
        this.nbt = nbt;
    }

    public MessageTileSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    implements IMessageHandler<MessageTileSync, IMessage> {
        public IMessage onMessage(MessageTileSync message, MessageContext ctx) {
            TileEntity tile;
            WorldServer world = DimensionManager.getWorld((int)message.dimension);
            if (world != null && (tile = world.getTileEntity(message.x, message.y, message.z)) instanceof TileEntityIEBase) {
                ((TileEntityIEBase)tile).receiveMessageFromClient(message.nbt);
            }
            return null;
        }
    }
}

