/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualPages;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ManualUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof String) {
            return ManualUtils.compareToOreName(stack, (String)o);
        }
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        return false;
    }

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oid).equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, double ... uv) {
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        tes.addVertexWithUV((double)x, (double)(y + h), 0.0, uv[0], uv[3]);
        tes.addVertexWithUV((double)(x + w), (double)(y + h), 0.0, uv[1], uv[3]);
        tes.addVertexWithUV((double)(x + w), (double)y, 0.0, uv[1], uv[2]);
        tes.addVertexWithUV((double)x, (double)y, 0.0, uv[0], uv[2]);
        tes.draw();
    }

    public static ArrayList<String> getPrimitiveSpellingCorrections(String query, String[] valid, int maxDistance) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : valid) {
            if (s == null || s.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s) >= maxDistance) continue;
            list.add(s);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return ManualUtils.getSpellingDistanceBetweenStrings(s1, s0);
            }
        });
        return list;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase();
        target = target.toLowerCase();
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += targetWords[iWord].length() - queryWords[iWord].length();
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void drawSplitString(FontRenderer fontRenderer, String string, int x, int y, int width, int colour) {
        fontRenderer.resetStyles();
        fontRenderer.textColor = colour;
        List list = fontRenderer.listFormattedStringToWidth(string, width);
        FloatBuffer currentGLColor = BufferUtils.createFloatBuffer((int)16);
        for (String next : list) {
            int currentColour = fontRenderer.textColor;
            GL11.glGetFloat((int)2816, (FloatBuffer)currentGLColor);
            if (currentGLColor.get(0) != (float)(currentColour >> 16 & 0xFF) / 255.0f || currentGLColor.get(1) != (float)(currentColour >> 8 & 0xFF) / 255.0f || currentGLColor.get(2) != (float)(currentColour & 0xFF) / 255.0f) {
                fontRenderer.textColor = colour;
            }
            fontRenderer.drawString(next, x, y, fontRenderer.textColor, false);
            y += fontRenderer.FONT_HEIGHT;
        }
    }

    public static Tessellator tes() {
        return Tessellator.instance;
    }

    public static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static void bindTexture(String path) {
        ManualUtils.mc().getTextureManager().bindTexture(ManualUtils.getResource(path));
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static Object[] getRecipeForDisplay(IRecipe rec) {
        Object[] ingredientsPre = null;
        int w = 0;
        int h = 0;
        if (rec instanceof ShapelessRecipes) {
            ingredientsPre = ((ShapelessRecipes)rec).recipeItems.toArray();
            int n = ingredientsPre.length > 6 ? 3 : (w = ingredientsPre.length > 1 ? 2 : 1);
            h = ingredientsPre.length > 4 ? 3 : (ingredientsPre.length > 2 ? 2 : 1);
        } else if (rec instanceof ShapelessOreRecipe) {
            ingredientsPre = ((ShapelessOreRecipe)rec).getInput().toArray();
            int n = ingredientsPre.length > 6 ? 3 : (w = ingredientsPre.length > 1 ? 2 : 1);
            h = ingredientsPre.length > 4 ? 3 : (ingredientsPre.length > 2 ? 2 : 1);
        } else if (rec instanceof ShapedOreRecipe) {
            ingredientsPre = ((ShapedOreRecipe)rec).getInput();
            w = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)rec), (String[])new String[]{"width"});
            h = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)rec), (String[])new String[]{"height"});
        } else if (rec instanceof ShapedRecipes) {
            ingredientsPre = ((ShapedRecipes)rec).recipeItems;
            w = ((ShapedRecipes)rec).recipeWidth;
            h = ((ShapedRecipes)rec).recipeHeight;
        } else {
            try {
                IELogger.info("Found custom IRecipe with output " + rec.getRecipeOutput());
            }
            catch (Exception x) {
                IELogger.info("Found custom IRecipe with unknown output");
            }
            return null;
        }
        Object[] ingredients = new Object[ingredientsPre.length];
        for (int iO = 0; iO < ingredientsPre.length; ++iO) {
            if (ingredientsPre[iO] instanceof List) {
                ingredients[iO] = new ArrayList((List)ingredientsPre[iO]);
                Iterator itValidate = ((ArrayList)ingredients[iO]).iterator();
                while (itValidate.hasNext()) {
                    ItemStack stVal = (ItemStack)itValidate.next();
                    if (stVal != null && stVal.getItem() != null && stVal.getDisplayName() != null) continue;
                    itValidate.remove();
                }
                continue;
            }
            ingredients[iO] = ingredientsPre[iO];
        }
        ManualPages.PositionedItemStack[] pIngredients = new ManualPages.PositionedItemStack[ingredients.length + 1];
        int xBase = (120 - (w + 2) * 18) / 2;
        for (int hh = 0; hh < h; ++hh) {
            for (int ww = 0; ww < w; ++ww) {
                if (hh * w + ww >= ingredients.length) continue;
                pIngredients[hh * w + ww] = new ManualPages.PositionedItemStack(ingredients[hh * w + ww], xBase + ww * 18, hh * 18);
            }
        }
        pIngredients[pIngredients.length - 1] = new ManualPages.PositionedItemStack(rec.getRecipeOutput(), xBase + w * 18 + 18, (int)((float)h / 2.0f * 18.0f) - 8);
        return new Object[]{w, h, pIngredients};
    }
}

