/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEIActions;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class ServerHandler {
    private static ServerHandler instance;

    public static void load() {
        instance = new ServerHandler();
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEISPH());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        NEIActions.init();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.isRemote && NEIServerConfig.dimTags.containsKey(CommonUtils.getDimension((World)event.world))) {
            this.processDisabledProperties(event.world);
        }
    }

    @SubscribeEvent
    public void loadEvent(WorldEvent.Load event) {
        if (!event.world.isRemote) {
            NEIServerConfig.load(event.world);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerSave save = NEIServerConfig.forPlayer(player.getCommandSenderName());
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            save.updateOpChange(player);
            save.save();
        }
    }

    private void processDisabledProperties(World world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isActionDisabled(CommonUtils.getDimension((World)world), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(EntityPlayerMP player, PlayerSave save) {
        if (!save.isActionEnabled("magnet") || player.isDead) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.worldObj.getEntitiesWithinAABB(EntityItem.class, player.boundingBox.expand((double)distancexz, (double)distancey, (double)distancexz));
        for (EntityItem item : items) {
            double rationspeedy;
            if (item.delayBeforeCanPickup > 0 || !NEIServerUtils.canItemFitInInventory((EntityPlayer)player, item.getEntityItem())) continue;
            if (item.delayBeforeCanPickup == 0) {
                NEISPH.sendAddMagneticItemTo(player, item);
            }
            double dx = player.posX - item.posX;
            double dy = player.posY + (double)player.getEyeHeight() - item.posY;
            double dz = player.posZ - item.posZ;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.onCollideWithPlayer((EntityPlayer)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.motionX + speedxz * dx;
            double vy = item.motionY + speedy * dy;
            double vz = item.motionZ + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            item.motionX = vx;
            item.motionY = vy;
            item.motionZ = vz;
        }
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NEIServerConfig.loadPlayer(event.player);
        NEISPH.sendHasServerSideTo((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void logoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NEIServerConfig.unloadPlayer(event.player);
    }

    @SubscribeEvent
    public void dimChangeEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        NEISPH.sendHasServerSideTo((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerRespawnEvent event) {
        NEISPH.sendHasServerSideTo((EntityPlayerMP)event.player);
    }
}

