/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts.locomotive;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.locomotive.LocomotiveModelRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum LocomotiveRenderType {
    STEAM_SOLID("cart.loco.steam.solid"),
    STEAM_MAGIC("cart.loco.steam.magic"),
    ELECTRIC("cart.loco.electric");

    private final Map<String, LocomotiveModelRenderer> renderers = new HashMap<String, LocomotiveModelRenderer>();
    private final String cartTag;

    private LocomotiveRenderType(String cartTag) {
        this.cartTag = cartTag;
    }

    public void registerRenderer(LocomotiveModelRenderer renderer) {
        this.renderers.put(renderer.getRendererTag(), renderer);
    }

    public void registerIcons(IIconRegister iconRegister) {
        HashSet<LocomotiveModelRenderer> set = new HashSet<LocomotiveModelRenderer>(this.renderers.values());
        for (LocomotiveModelRenderer renderer : set) {
            renderer.registerItemIcons(iconRegister);
        }
    }

    public LocomotiveModelRenderer getRenderer(String tag) {
        LocomotiveModelRenderer renderer = this.renderers.get(tag);
        if (renderer == null) {
            renderer = this.renderers.get("railcraft:default");
        }
        return renderer;
    }

    public ItemStack getItemWithRenderer(String rendererTag) {
        ItemStack stack = GameRegistry.findItemStack((String)"Railcraft", (String)this.cartTag, (int)1);
        return this.getItemWithRenderer(rendererTag, stack);
    }

    public ItemStack getItemWithRenderer(String rendererTag, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setString("model", rendererTag);
        stack.setTagCompound(nbt);
        return stack;
    }

    public Set<String> getRendererTags() {
        return this.renderers.keySet();
    }
}

