/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.core;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class WorldCoordinate
implements Comparable<WorldCoordinate> {
    public final int dimension;
    public final int x;
    public final int y;
    public final int z;

    public WorldCoordinate(int dimension, int x, int y, int z) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WorldCoordinate(TileEntity tile) {
        this.dimension = tile.getWorldObj().provider.dimensionId;
        this.x = tile.xCoord;
        this.y = tile.yCoord;
        this.z = tile.zCoord;
    }

    public static WorldCoordinate readFromNBT(NBTTagCompound data, String tag) {
        if (data.hasKey(tag)) {
            NBTTagCompound nbt = data.getCompoundTag(tag);
            int dim = nbt.getInteger("dim");
            int x = nbt.getInteger("x");
            int y = nbt.getInteger("y");
            int z = nbt.getInteger("z");
            return new WorldCoordinate(dim, x, y, z);
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setInteger("dim", this.dimension);
        nbt.setInteger("x", this.x);
        nbt.setInteger("y", this.y);
        nbt.setInteger("z", this.z);
        data.setTag(tag, (NBTBase)nbt);
    }

    public boolean isInSameChunk(WorldCoordinate otherCoord) {
        return this.dimension == otherCoord.dimension && this.x >> 4 == otherCoord.x >> 4 && this.z >> 4 == otherCoord.z >> 4;
    }

    public boolean isEqual(int dim, int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z && this.dimension == dim;
    }

    @Override
    public int compareTo(WorldCoordinate o) {
        if (this.dimension != o.dimension) {
            return this.dimension - o.dimension;
        }
        if (this.x != o.x) {
            return this.x - o.x;
        }
        if (this.y != o.y) {
            return this.y - o.y;
        }
        if (this.z != o.z) {
            return this.z - o.z;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorldCoordinate other = (WorldCoordinate)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "WorldCoordinate{dimension=" + this.dimension + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

