/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.electricity;

import java.util.Random;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface IElectricMinecart {
    public ChargeHandler getChargeHandler();

    public static final class ChargeHandler {
        static final int DRAW_INTERVAL = 8;
        private static final Random rand = new Random();
        private final EntityMinecart minecart;
        private final Type type;
        private double capacity;
        private double charge;
        private double draw;
        private double lastTickDraw;
        private final double lossPerTick;
        private int clock = rand.nextInt();
        private int drewFromTrack;

        public ChargeHandler(EntityMinecart minecart, Type type, double capactiy) {
            this(minecart, type, capactiy, 0.0);
        }

        public ChargeHandler(EntityMinecart minecart, Type type, double capacity, double lossPerTick) {
            this.minecart = minecart;
            this.type = type;
            this.capacity = capacity;
            this.lossPerTick = lossPerTick;
        }

        public double getCharge() {
            return this.charge;
        }

        public double getCapacity() {
            return this.capacity;
        }

        public double getLosses() {
            return this.lossPerTick;
        }

        public double getDraw() {
            return this.draw;
        }

        public Type getType() {
            return this.type;
        }

        public void setCharge(double charge) {
            if (this.type == Type.USER) {
                return;
            }
            this.charge = charge;
        }

        public void addCharge(double charge) {
            if (this.type == Type.USER) {
                return;
            }
            this.charge += charge;
        }

        public double removeCharge(double request) {
            if (request <= 0.0) {
                return 0.0;
            }
            if (this.charge >= request) {
                this.charge -= request;
                this.lastTickDraw += request;
                return request;
            }
            double ret = this.charge;
            this.charge = 0.0;
            this.lastTickDraw += ret;
            return ret;
        }

        private void removeLosses() {
            if (this.lossPerTick > 0.0) {
                this.charge = this.charge >= this.lossPerTick ? (this.charge -= this.lossPerTick) : 0.0;
            }
        }

        public void tick() {
            ++this.clock;
            this.removeLosses();
            this.draw = (this.draw * 49.0 + this.lastTickDraw) / 50.0;
            this.lastTickDraw = 0.0;
            if (this.drewFromTrack > 0) {
                --this.drewFromTrack;
            } else if (this.type == Type.USER && this.charge < this.capacity / 2.0 && this.clock % 8 == 0) {
                ILinkageManager lm = CartTools.getLinkageManager(this.minecart.worldObj);
                for (EntityMinecart cart : lm.getCartsInTrain(this.minecart)) {
                    ChargeHandler ch;
                    if (!(cart instanceof IElectricMinecart) || (ch = ((IElectricMinecart)cart).getChargeHandler()).getType() == Type.USER || !(ch.getCharge() > 0.0)) continue;
                    this.charge += ch.removeCharge(this.capacity - this.charge);
                    break;
                }
            }
        }

        public void tickOnTrack(int trackX, int trackY, int trackZ) {
            IElectricGrid track;
            if (this.type == Type.USER && this.charge < this.capacity && this.clock % 8 == 0 && (track = RailTools.getTrackObjectAt(this.minecart.worldObj, trackX, trackY, trackZ, IElectricGrid.class)) != null) {
                double drawnFromTrack = track.getChargeHandler().removeCharge(this.capacity - this.charge);
                if (drawnFromTrack > 0.0) {
                    this.drewFromTrack = 32;
                }
                this.charge += drawnFromTrack;
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setDouble("charge", this.charge);
            nbt.setTag("chargeHandler", (NBTBase)tag);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = nbt.getCompoundTag("chargeHandler");
            this.charge = tag.getDouble("charge");
        }

        public static enum Type {
            USER,
            SOURCE,
            STORAGE;

        }
    }
}

