/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import mods.railcraft.api.tracks.RailTools;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrackScanner {
    public static boolean areTracksConnectedAlongAxis(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        return TrackScanner.scanStraightTrackSection((World)world, (int)x1, (int)y1, (int)z1, (int)x2, (int)y2, (int)z2).verdict == ScanResult.Verdict.VALID;
    }

    public static ScanResult scanStraightTrackSection(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        int maxY;
        int minY;
        block14: {
            int yy;
            int max;
            int min;
            block13: {
                int yy2;
                int max2;
                int min2;
                minY = Math.min(y1, y2);
                maxY = Math.max(y1, y2);
                if (x1 != x2 && z1 != z2) {
                    return new ScanResult(ScanResult.Verdict.NOT_ALIGNED, minY, maxY);
                }
                if (x1 == x2) break block13;
                if (x1 < x2) {
                    min2 = x1;
                    max2 = x2;
                    yy2 = y1;
                } else {
                    min2 = x2;
                    max2 = x1;
                    yy2 = y2;
                }
                for (int xx = min2; xx <= max2; ++xx) {
                    if (RailTools.isRailBlockAt((IBlockAccess)world, xx, yy2, z1)) continue;
                    if (RailTools.isRailBlockAt((IBlockAccess)world, xx, yy2 - 1, z1)) {
                        if (--yy2 >= minY) continue;
                        minY = yy2;
                        continue;
                    }
                    if (RailTools.isRailBlockAt((IBlockAccess)world, xx, yy2 + 1, z1)) {
                        if (++yy2 <= maxY) continue;
                        maxY = yy2;
                        continue;
                    }
                    if (!world.blockExists(xx, yy2, z1)) {
                        return new ScanResult(ScanResult.Verdict.UNKNOWN, minY, maxY);
                    }
                    return new ScanResult(ScanResult.Verdict.PATH_NOT_FOUND, minY, maxY);
                }
                break block14;
            }
            if (z1 == z2) break block14;
            if (z1 < z2) {
                min = z1;
                max = z2;
                yy = y1;
            } else {
                min = z2;
                max = z1;
                yy = y2;
            }
            for (int zz = min; zz <= max; ++zz) {
                if (RailTools.isRailBlockAt((IBlockAccess)world, x1, yy, zz)) continue;
                if (RailTools.isRailBlockAt((IBlockAccess)world, x1, yy - 1, zz)) {
                    if (--yy >= minY) continue;
                    minY = yy;
                    continue;
                }
                if (RailTools.isRailBlockAt((IBlockAccess)world, x1, yy + 1, zz)) {
                    if (++yy <= maxY) continue;
                    maxY = yy;
                    continue;
                }
                if (!world.blockExists(x1, yy, zz)) {
                    return new ScanResult(ScanResult.Verdict.UNKNOWN, minY, maxY);
                }
                return new ScanResult(ScanResult.Verdict.PATH_NOT_FOUND, minY, maxY);
            }
        }
        return new ScanResult(ScanResult.Verdict.VALID, minY, maxY);
    }

    public static class ScanResult {
        public final Verdict verdict;
        public final boolean areConnected;
        public final int minY;
        public final int maxY;

        public ScanResult(Verdict verdict, int minY, int maxY) {
            this.verdict = verdict;
            this.areConnected = verdict == Verdict.VALID;
            this.minY = minY;
            this.maxY = maxY;
        }

        public static enum Verdict {
            VALID,
            UNKNOWN,
            NOT_ALIGNED,
            PATH_NOT_FOUND;

        }
    }
}

