/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.common.gui.containers.ContainerAnvil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAnvil
extends GuiContainer
implements ICrafting {
    private static final ResourceLocation anvilGuiTextures = new ResourceLocation("textures/gui/container/anvil.png");
    private ContainerRepair repairContainer;
    private GuiTextField itemNameField;
    private InventoryPlayer playerInv;

    public GuiAnvil(InventoryPlayer playerInv, World world, int x, int y, int z) {
        super((Container)new ContainerAnvil(playerInv, world, x, y, z, (EntityPlayer)Minecraft.getMinecraft().thePlayer));
        this.playerInv = playerInv;
        this.repairContainer = (ContainerRepair)this.inventorySlots;
    }

    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        this.itemNameField = new GuiTextField(this.fontRendererObj, i + 62, j + 24, 103, 12);
        this.itemNameField.setTextColor(-1);
        this.itemNameField.setDisabledTextColour(-1);
        this.itemNameField.setEnableBackgroundDrawing(false);
        this.itemNameField.setMaxStringLength(40);
        this.inventorySlots.removeCraftingFromCrafters((ICrafting)this);
        this.inventorySlots.addCraftingToCrafters((ICrafting)this);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
        this.inventorySlots.removeCraftingFromCrafters((ICrafting)this);
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        GL11.glDisable((int)2896);
        this.fontRendererObj.drawString(I18n.format((String)"container.repair", (Object[])new Object[0]), 60, 6, 0x404040);
        if (this.repairContainer.maximumCost > 0) {
            int k = 8453920;
            boolean flag = true;
            String s = I18n.format((String)"container.repair.cost", (Object[])new Object[]{this.repairContainer.maximumCost});
            if (this.repairContainer.maximumCost >= 40 && !this.mc.thePlayer.capabilities.isCreativeMode) {
                s = I18n.format((String)"container.repair.expensive", (Object[])new Object[0]);
                k = 0xFF6060;
            } else if (!this.repairContainer.getSlot(2).getHasStack()) {
                flag = false;
            } else if (!this.repairContainer.getSlot(2).canTakeStack(this.playerInv.player)) {
                k = 0xFF6060;
            }
            if (flag) {
                int l = 0xFF000000 | (k & 0xFCFCFC) >> 2 | k & 0xFF000000;
                int i1 = this.xSize - 8 - this.fontRendererObj.getStringWidth(s);
                int b0 = 67;
                if (this.fontRendererObj.getUnicodeFlag()) {
                    GuiAnvil.drawRect((int)(i1 - 3), (int)(b0 - 2), (int)(this.xSize - 7), (int)(b0 + 10), (int)-16777216);
                    GuiAnvil.drawRect((int)(i1 - 2), (int)(b0 - 1), (int)(this.xSize - 8), (int)(b0 + 9), (int)-12895429);
                } else {
                    this.fontRendererObj.drawString(s, i1, b0 + 1, l);
                    this.fontRendererObj.drawString(s, i1 + 1, b0, l);
                    this.fontRendererObj.drawString(s, i1 + 1, b0 + 1, l);
                }
                this.fontRendererObj.drawString(s, i1, b0, k);
            }
        }
        GL11.glEnable((int)2896);
    }

    protected void keyTyped(char par1, int par2) {
        if (this.itemNameField.textboxKeyTyped(par1, par2)) {
            this.func_135015_g();
        } else {
            super.keyTyped(par1, par2);
        }
    }

    private void func_135015_g() {
        String s = this.itemNameField.getText();
        Slot slot = this.repairContainer.getSlot(0);
        if (slot != null && slot.getHasStack() && !slot.getStack().hasDisplayName() && s.equals(slot.getStack().getDisplayName())) {
            s = "";
        }
        this.repairContainer.updateItemName(s);
        this.mc.thePlayer.sendQueue.addToSendQueue((Packet)new C17PacketCustomPayload("MC|ItemName", s.getBytes()));
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
        this.itemNameField.mouseClicked(par1, par2, par3);
    }

    public void drawScreen(int par1, int par2, float par3) {
        super.drawScreen(par1, par2, par3);
        GL11.glDisable((int)2896);
        this.itemNameField.drawTextBox();
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(anvilGuiTextures);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(k + 59, l + 20, 0, this.ySize + (this.repairContainer.getSlot(0).getHasStack() ? 0 : 16), 110, 16);
        if ((this.repairContainer.getSlot(0).getHasStack() || this.repairContainer.getSlot(1).getHasStack()) && !this.repairContainer.getSlot(2).getHasStack()) {
            this.drawTexturedModalRect(k + 99, l + 45, this.xSize, 0, 28, 21);
        }
    }

    public void sendContainerAndContentsToPlayer(Container par1Container, List par2List) {
        this.sendSlotContents(par1Container, 0, par1Container.getSlot(0).getStack());
    }

    public void sendSlotContents(Container par1Container, int par2, ItemStack par3ItemStack) {
        if (par2 == 0) {
            this.itemNameField.setText(par3ItemStack == null ? "" : par3ItemStack.getDisplayName());
            this.itemNameField.setEnabled(par3ItemStack != null);
            if (par3ItemStack != null) {
                this.func_135015_g();
            }
        }
    }

    public void sendProgressBarUpdate(Container par1Container, int par2, int par3) {
    }
}

