/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.common.blocks.signals.TileBoxAnalogController;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.opengl.GL11;

public class GuiBoxAnalogController
extends GuiBasic {
    private final TileBoxAnalogController tile;
    private static final Pattern patternRange = Pattern.compile("(\\d+)-(\\d+)|(\\d+)");
    private final EnumMap<SignalAspect, BitSet> aspects = new EnumMap(SignalAspect.class);
    private final EnumMap<SignalAspect, GuiTextField> textbox = new EnumMap(SignalAspect.class);

    public GuiBoxAnalogController(TileBoxAnalogController tile) {
        super(tile.getName(), "railcraft:textures/gui/gui_basic_large.png", 176, 113);
        this.tile = tile;
        for (Map.Entry<SignalAspect, BitSet> entry : tile.aspects.entrySet()) {
            this.aspects.put((SignalAspect)((Enum)entry.getKey()), (BitSet)entry.getValue().clone());
        }
    }

    public void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        for (GuiTextField t : this.textbox.values()) {
            t.mouseClicked(i, j, k);
        }
    }

    @Override
    public void keyTyped(char c, int i) {
        super.keyTyped(c, i);
        if (c < ' ' || c >= '0' && c <= '9' || c == '-' || c == ',' || c > '~') {
            for (GuiTextField t : this.textbox.values()) {
                t.textboxKeyTyped(c, i);
            }
        }
    }

    private String rangeToString(BitSet b) {
        String s = "";
        int start = -1;
        for (int i = 0; i < 16; ++i) {
            if (b.get(i)) {
                if (start != -1) continue;
                s = s + i;
                start = i;
                continue;
            }
            if (start == -1) continue;
            s = i - 1 == start ? s + "," : s + "-" + (i - 1) + ",";
            start = -1;
        }
        if (start != -1 && start != 15) {
            s = s + "-15";
            start = 15;
        }
        if (s.isEmpty() || start == 15) {
            return s;
        }
        return s.substring(0, s.length() - 1);
    }

    private void parseRegex(String regex, BitSet bits) {
        bits.clear();
        Matcher m = patternRange.matcher(regex);
        while (m.find()) {
            if (m.groupCount() >= 3 && m.group(3) != null) {
                int i = Integer.parseInt(m.group(3));
                if (i < 0 || i > 15) continue;
                bits.set(i);
                continue;
            }
            int start = Integer.parseInt(m.group(1));
            int end = Integer.parseInt(m.group(2));
            if (start < 0 || end < 0 || start > 15 || end > 15 || start > end) continue;
            for (int i = start; i <= end; ++i) {
                bits.set(i);
            }
        }
    }

    public void initGui() {
        if (this.tile == null) {
            return;
        }
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            GuiTextField textField = new GuiTextField(this.fontRendererObj, w + 72, h + GuiBoxAnalogController.getYPosFromIndex(entry.getKey().ordinal()), 95, 10);
            textField.setMaxStringLength(37);
            textField.setText(this.rangeToString(entry.getValue()));
            this.textbox.put((SignalAspect)((Enum)entry.getKey()), textField);
        }
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        super.drawScreen(x, y, f);
        GL11.glDisable((int)2896);
        for (GuiTextField t : this.textbox.values()) {
            t.drawTextBox();
        }
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        for (SignalAspect aspect : SignalAspect.VALUES) {
            GuiBoxAnalogController.drawAlignedString(this.fontRendererObj, LocalizationPlugin.translate(aspect.getLocalizationTag()), 10, GuiBoxAnalogController.getYPosFromIndex(aspect.ordinal()) + 1, 50);
        }
    }

    @Override
    public void updateScreen() {
        for (GuiTextField t : this.textbox.values()) {
            t.updateCursorCounter();
        }
        super.updateScreen();
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
                this.parseRegex(this.textbox.get((Object)entry.getKey()).getText(), entry.getValue());
            }
            this.tile.aspects = this.aspects;
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    private static void drawAlignedString(FontRenderer fr, String s, int x, int y, int width) {
        fr.drawString(s, x + (width - fr.getStringWidth(s)) / 2, y, 0x404040);
    }

    private static int getYPosFromIndex(int i) {
        return 22 + i * 14;
    }
}

